from typing import Union

JSON: type = Union[None, str, int, bool, float, list['JSON'], dict[str, 'JSON']]


def is_json(json: JSON) -> bool:
    if json is None or isinstance(json, str) or isinstance(json, int) or isinstance(json, bool) or \
            isinstance(json, float):
        return True
    elif isinstance(json, list):
        return all(is_json(value) for value in json)
    elif isinstance(json, dict):
        return all(isinstance(key, str) for key in json.keys()) and all(is_json(value) for value in json.values())
    else:
        return False
