def get_class_name(obj: object) -> str:
    return f'{obj.__module__}.{obj.__qualname__}'


def get_object_name(obj: object) -> str:
    return get_class_name(obj.__class__)


def create_range(s: slice, length: int) -> range:
    assert s.start is None or s.start >= 0, f'slice start must be greater than or equal to 0: {s}'
    assert s.stop is None or s.stop <= length, f'slice stop must be less than or equal to {length}: {s}'
    assert s.step is None or s.step > 0, f'slice step must be greater than 0: {s}'
    return range(
        s.start if s.start is not None else 0,
        s.stop if s.stop is not None else length,
        s.step if s.step is not None else 1
    )
