from refinement.graph import Node, depth_first_traversal
from refinement.goal import Goal
from env.lunar_lander import Lander

train_env = Lander()
test_env = Lander(render_mode = None)

start = Goal(lower_bound=[0, 3], upper_bound=[3, 5], index_range=[0, 1,])
end = Goal(lower_bound=[-0.05, -0.05], upper_bound=[0.2, 0.05], index_range=[0, 1])



start_node = Node(start, False, False, "start")
# mid_node = Node(mid_region, True, False, "mid")
goal_node = Node(end, True, True, "goal")

start_node.add_child(goal_node)
depth_first_traversal(start_node, train_env, test_env, 0.9, 80000, 100, ".")


