import numpy as np
from scipy.spatial import ConvexHull

class Region():

    def __init__(self, polygon):
        
        self.polygon = polygon
        
        self.extended_region = []
        
    def in_region(self, state):
        # Check if line segment intersects with the rectangle
        if not np.all(self.polygon[:,:-1] @ state.reshape(-1, 1) <= self.polygon[:,-1].reshape(-1, 1)):
            return True
        
        # Check if line segment intersects with any convex hull
        truth_values = [False]
        
        for hull in self.extended_region:
            truth_values.append(any(np.dot(eq[:-1], state) + eq[-1] > 0) for eq in hull.equations)
        
        return any(truth_values)
    
    def extend_region(self, list_of_points):
        hull = ConvexHull(list_of_points)
        self.extended_region.append(hull)


class Avoid():
    
    def __init__(self, list_of_regions):
        
        self.list_of_regions = list_of_regions
    
    def check_trigger(self, state):
        
        for region in self.list_of_regions:
            if region.in_region(state):
                return True
        return False
    
    def check_region(self, state):
        
        for region in self.list_of_regions:
            if region.in_region(state):
                return region
        return None
    
    def reward(self, state:np.ndarray,):
        region = self.check_region(state)
        if region:
            return -10
        else:
            return 0