import json
import importlib.util

def load_class_from_file(file_path, class_name):
    # Dynamically load the module
    spec = importlib.util.spec_from_file_location("module.name", file_path)
    module = importlib.util.module_from_spec(spec)
    spec.loader.exec_module(module)
    
    # Get the class by name
    cls = getattr(module, class_name)
    
    return cls

def load_classes_from_config(config):
    # Load Expert class
    expert_config = config[0]['Expert']
    ExpertClass = load_class_from_file(expert_config['file_path'], expert_config['class_name'])
    
    # Load Solver class
    solver_config = config[1]['Solver']
    SolverClass = load_class_from_file(solver_config['file_path'], solver_config['class_name'])
    
    # Delete both entries from the loaded config after use
    del config[0]
    del config[0]
    
    # Return the class objects so they can be instantiated later
    return ExpertClass, SolverClass, config

def load_one_agent_from_config(config):
    # Load Expert class
    agent_config = config[0]['Agent']
    AgentClass = load_class_from_file(agent_config['file_path'], agent_config['class_name'])
    
    # Delete both entries from the loaded config after use
    del config[0]
    
    # Return the class objects so they can be instantiated later
    return AgentClass, config