# from transformers import AutoModelForCausalLM, AutoTokenizer
# from transformers.generation import GenerationConfig
# import torch
# torch.manual_seed(1234)

from agents.agent import Agent
import json
import os
import random


class RandomAgent(Agent):
    def __init__(self, role="SOLVER") -> None:
        super(RandomAgent, self).__init__(role)
      

    def clear(self):
        self.conversation = []

    # Given conversation history, respond to message.
    def respond(self, image_data, actions, message=None):

        ret = self.get_conversation_history_string(
            image_data=image_data, actions=actions, message=message, model="random")
        actions = ret.strip().split("\n")[1:]
        return random.choice(actions)

