import json
import os
from agents.agent import Agent

class GenericAgent(Agent):
    def __init__(self, role="AGENT") -> None:
        """
        Initialize the agent. Init your model accordingly.
        """
        self.role = role
        # List of strings. Each element (string) represents a message alternating between the agent and the user
        self.conversation = []

    def clear(self):
        """
        Clears the conversation history.
        """
        self.conversation = []

    def respond(self, input_data, actions, message=None):
        """
        Respond based on the given conversation history. Return the predicted action.
        Implement model-specific behavior here.

        Args:
            input_data: Data to process (e.g., image, text, etc.).
            actions: Any additional actions to consider when generating the response.
            message: Optional message input.

        Returns:
            predicted_action: The response generated by the model.
        """
        # Implement conversation history string formation here, if needed
        # ret = self.get_conversation_history_string(input_data=input_data, actions=actions, message=message)

        # Placeholder: Replace with actual input/output handling based on your model
        model_input = message if message else "Default input"

        # Send request to the model (this is a placeholder, replace with actual logic)
        # For example: response = self.client.chat.completions.create(model_input=model_input)
        # response_text = response.choices[0].message.content

        # Simulate a predicted action (replace with actual model's response)
        predicted_action = f"Simulated response for input: {model_input}"

        # Append to conversation history
        self.conversation.append(predicted_action)

        return predicted_action
