import itertools
import json

# 定义 display_text 列表和 button_text 列表
display_text_list = [1, 2, 3, 4]
button_text_list = ["1", "2", "3", "4"]

# 生成所有 button_text 的排列组合
button_permutations = list(itertools.permutations(button_text_list))

# 生成所有 display_text 可能值和每个 button_text 排列组合
all_combinations = []
for display_text in display_text_list:
    for button_texts in button_permutations:
        scenario = {
            "display_text": display_text,
            "button_texts": button_texts
        }
        all_combinations.append(scenario)

# 将所有可能的情况写入JSON文件
with open('memory.json', 'w') as json_file:
    json.dump(all_combinations, json_file, indent=4)