from modules.module import Module
from modules.util import HighlightButton

# Template for adding a puzzle to our framework
# Remember to also add the instructions for the puzzle in natural text to config/prompts.json
# Optionally, if the instructions require an image, you may include an image of the puzzle
# in images/manuals/<Name of your puzzle>.jpg. The name should be the same as the string representation
# of this class (see bottom)
class ExamplePuzzle(Module):
    def __init__(self, game_manager):
        super(ExamplePuzzle, self).__init__(game_manager)

        if self.game_manager.config: # If you have some config for the puzzle, you can load it here
            my_config = self.game_manager.config[self.game_manager.cur_puzzle][str(self)]
        else: # Some initialization logic
            pass

        # Create some buttons / canvas elements if you like
        # This defines a button, which has a handler called on_submit()
        send_button = HighlightButton(
            self, 
            self.width / 2 - 80,    # Top Left X
            425,                    # Top Left Y
            160,                    # Button Width
            40,                     # Button Height
            text="SUBMIT",          # Text Displayed on Button
            command=self.on_submit) # Handler after pressing button
        
        # When adding buttons, make sure to add them to self.buttons
        self.buttons.append(send_button)

        pass

    def send_info_to_solver(self):
        # Define the list of possible actions here. Add each action to self.actions
        self.actions.append({"type": "button", # Type of action (either button, or press and hold)
                             "name": f"press_button", # The name of the action (given to the solver in prompt)
                             "x_coord": (55 + 320) / 2, # X coordinate used for pyautogui
                             "y_coord": (155 + 420) / 2}) # Y coordinate used for pyautogui
        super().send_info_to_solver()

    # Example handler behavior for when UI element is clicked.
    def on_submit(self, event=None):
        self.finish_check() # This function checks if the puzzle in its current state if correct and finished.

    # Input: The Solver's Message
    # This function should parse the solver's message and invoke any actions the solver wants
    # in the message.
    # Returns True if the solver executed an action. Returns False otherwise.
    def execute_action(self, message):
        if f"press_button" in message:
            self.on_submit()
            return True
        return False
    
    # Function to check if the current state of the puzzle is the final correct one.
    # Called when finish_check() is called.
    def check_correct(self):
        timer_text = self.timer_label.cget("text")
        return "0" in timer_text
        
    # String representation of the puzzle
    def __str__(self):
        return "ExamplePuzzle"