#!/bin/bash

# Default behavior (without GUI)
use_gui=false

# Parse command-line arguments
while [[ "$#" -gt 0 ]]; do
    case $1 in
        --gui) use_gui=true ;;  # Set use_gui to true if --gui is passed
    esac
    shift
done

cd .. # Helps avoid directory issues
file="config/experiment_config.json"


if [ "$use_gui" = true ]; then
    echo "Running: python main.py --model_config $file"
    python main.py --model_config "$file" # Run with GUI
else
    echo "Running: xvfb-run --auto-servernum --server-num=1 python main.py --model_config $file"
    xvfb-run --auto-servernum --server-num=1 python main.py --model_config "$file" # Run without GUI
fi

done