import numpy as np
import pandas as pd
from datasetsforecast.m5 import M5
import os
import policy_selection_for_inventories


if(__name__ == "__main__") :
    # Loading all M5 data
    Y_df, X_df, S_df = M5.load(os.path.join(policy_selection_for_inventories.__path__[0], "..", "..", "data"), cache=False)

    demands_df = Y_df.merge(S_df[["unique_id", "item_id", "cat_id"]], on="unique_id")
    
    demands_df.groupby(["ds"])["y"].sum().to_csv(os.path.join(
        policy_selection_for_inventories.__path__[0], "..", "..", "data","m5_processed","demands_total.csv"
    ))

    demands_df.groupby(["cat_id", "ds"])["y"].sum().to_csv(os.path.join(
        policy_selection_for_inventories.__path__[0], "..", "..", "data","m5_processed","demands_category.csv"
    ))

    demands_df.groupby(["item_id", "ds"])["y"].sum().to_csv(os.path.join(
        policy_selection_for_inventories.__path__[0], "..", "..", "data","m5_processed","demands_product.csv"
    ))