import random

# X_i is a sequence of of integers in [0,m-1] with the following properties:
# - in every m consecutive X_i (i.e. the sequence X_i with i in [j, j+m-1]), each of the values in [0,m-1] appears exactly once
# - X_i = X_i+m (i.e. the sequence of X_i is periodic)
# So the X_i is a randomly-ordered sequence of the integers 0..m-1, which repeats itself
def generate_Xi(a, c, m, b, X_0):
    Xi_list = [X_0]
    b_len = len(b)
    b_clique_sizes = [b_len-i+1 for i in range(b_len)]
    Xi_length = sum([no_cliques*clique_size for no_cliques, clique_size in zip(b, b_clique_sizes)])+1
    for i in range(1,Xi_length):
        mod_first_term = a*Xi_list[i-1]+c
        mod_second_term = m
        Xi_list.append((mod_first_term%mod_second_term))
    return Xi_list


# Y_i is the sequence obtained from the elements of X_i mod n
def generate_Yi(Xi_list, n):
    return [(Xi%n) for Xi in Xi_list]


def generate_clique_edges(vertex_list):
    # Given a set of vertices V, returns a list of the edges in the complete graph on V
    clique_edges = []
    for ind, vertex_1 in enumerate(vertex_list):
        for vertex_2 in vertex_list[ind+1:]:
            clique_edges.append((min(vertex_1, vertex_2), max(vertex_1, vertex_2)))
    return clique_edges


def generate_edges(n, k, m, c, a, b, X_0):
    Xi_list = generate_Xi(a, c, m, b, X_0)
    Yi_list = generate_Yi(Xi_list, n)

    graph_edges = []

    Y_ind = 1
    for i, b_value in enumerate(b):
        clique_size = k-i
        for _ in range(b_value):
            clique_vertices = Yi_list[Y_ind:Y_ind+clique_size]
            Y_ind+=clique_size
            clique_edges = generate_clique_edges(clique_vertices)
            graph_edges+=clique_edges

    graph_edges = set(graph_edges)

    return graph_edges


def generate_leighton_graph(n, k, X_0=None):
    # print('n: ', n)
    # print('k: ', k)
    m, c, a, b = generate_parameters(n, k)
    # print('m: ', m)
    # print('c: ', c)
    # print('a: ', a)
    # print('b: ', b)

    if X_0 is None:
        X_0 = generate_X0(m)

    # print('X_0: ', X_0)

    graph_edges = generate_edges(n, k, m, c, a, b, X_0)
    orig_vertex_names = [i for i in range(n)]
    target_edge_list = []
    target_edge_attr = []
    target_edge_indices = []
    ind=0
    edge_ind_dict = {vertex_name:{} for vertex_name in orig_vertex_names}
    for vertex1_ind, vertex1_name in enumerate(orig_vertex_names):
        for vertex2_name in orig_vertex_names[vertex1_ind+1:]:
            if not vertex1_name==vertex2_name:
                target_edge_attr.append(0)
                target_edge_attr.append(0)
                target_edge_list.append((vertex1_name, vertex2_name))
                edge_ind_dict[vertex1_name][vertex2_name] = ind
                ind+=1
                target_edge_list.append((vertex2_name, vertex1_name))
                edge_ind_dict[vertex2_name][vertex1_name] = ind
                ind+=1

    for edge in graph_edges:
        vertex1 = int(edge[0])
        vertex2 = int(edge[1])
        # print('edge_ind_dict:')
        # print(edge_ind_dict)
        # print('vertex1: ', vertex1)
        # print('vertex2: ', vertex2)
        ind1 = edge_ind_dict[vertex1][vertex2]
        target_edge_attr[ind1] = -1
        target_edge_indices.append(ind1)
        ind2 = edge_ind_dict[vertex2][vertex1]
        target_edge_attr[ind2] = -1
        target_edge_indices.append(ind2)
    
    return target_edge_list, target_edge_attr, edge_ind_dict, target_edge_indices

# PARAMETERS

def generate_m(n, k):
    # Choose m s.t.
    # m>>n
    # hcf(m,n) = k
    
    # m = 420175

    min_m = k*(n**2)
    primes_to_1000 = [2,3,5,7,11,13,17,19,23,29,31,37,41,43,47,53,59,61,67,71,73,79,83,89,97,101,103,107,109,113,127,131,137,139,149,151,157,163,167,173,179,181,191,193,197,199,211,223,227,229,233,239,241,251,257,263,269,271,277,281,283,293,307,311,313,317,331,337,347,349,353,359,367,373,379,383,389,397,401,409,419,421,431,433,439,443,449,457,461,463,467,479,487,491,499,503,509,521,523,541,547,557,563,569,571,577,587,593,599,601,607,613,617,619,631,641,643,647,653,659,661,673,677,683,691,701,709,719,727,733,739,743,751,757,761,769,773,787,797,809,811,821,823,827,829,839,853,857,859,863,877,881,883,887,907,911,919,929,937,941,947,953,967,971,977,983,991,997,1009,1013,1019,1021,1031,1033,1039,1049,1051,1061,1063,1069,1087,1091,1093,1097,1103,1109,1117,1123,1129,1151,1153,1163,1171,1181,1187,1193,1201,1213,1217,1223,1229,1231,1237,1249,1259,1277,1279,1283,1289,1291,1297,1301,1303,1307,1319,1321,1327,1361,1367,1373,1381,1399,1409,1423,1427,1429,1433,1439,1447,1451,1453,1459,1471,1481,1483,1487,1489,1493,1499,1511,1523,1531,1543,1549,1553,1559,1567,1571,1579,1583,1597,1601,1607,1609,1613,1619,1621,1627,1637,1657,1663,1667,1669,1693,1697,1699,1709,1721,1723,1733,1741,1747,1753,1759,1777,1783,1787,1789,1801,1811,1823,1831,1847,1861,1867,1871,1873,1877,1879,1889,1901,1907,1913,1931,1933,1949,1951,1973,1979,1987,1993,1997,1999,2003,2011,2017,2027,2029,2039,2053,2063,2069,2081,2083,2087,2089,2099,2111,2113,2129,2131,2137,2141,2143,2153,2161,2179,2203,2207,2213,2221,2237,2239,2243,2251,2267,2269,2273,2281,2287,2293,2297,2309,2311,2333,2339,2341,2347,2351,2357,2371,2377,2381,2383,2389,2393,2399,2411,2417,2423,2437,2441,2447,2459,2467,2473,2477,2503,2521,2531,2539,2543,2549,2551,2557,2579,2591,2593,2609,2617,2621,2633,2647,2657,2659,2663,2671,2677,2683,2687,2689,2693,2699,2707,2711,2713,2719,2729,2731,2741,2749,2753,2767,2777,2789,2791,2797,2801,2803,2819,2833,2837,2843,2851,2857,2861,2879,2887,2897,2903,2909,2917,2927,2939,2953,2957,2963,2969,2971,2999,3001,3011,3019,3023,3037,3041,3049,3061,3067,3079,3083,3089,3109,3119,3121,3137,3163,3167,3169,3181,3187,3191,3203,3209,3217,3221,3229,3251,3253,3257,3259,3271,3299,3301,3307,3313,3319,3323,3329,3331,3343,3347,3359,3361,3371,3373,3389,3391,3407,3413,3433,3449,3457,3461,3463,3467,3469,3491,3499,3511,3517,3527,3529,3533,3539,3541,3547,3557,3559,3571,3581,3583,3593,3607,3613,3617,3623,3631,3637,3643,3659,3671,3673,3677,3691,3697,3701,3709,3719,3727,3733,3739,3761,3767,3769,3779,3793,3797,3803,3821,3823,3833,3847,3851,3853,3863,3877,3881,3889,3907,3911,3917,3919,3923,3929,3931,3943,3947,3967,3989,4001,4003,4007,4013,4019,4021,4027,4049,4051,4057,4073,4079,4091,4093,4099,4111,4127,4129,4133,4139,4153,4157,4159,4177,4201,4211,4217,4219,4229,4231,4241,4243,4253,4259,4261,4271,4273,4283,4289,4297,4327,4337,4339,4349,4357,4363,4373,4391,4397,4409,4421,4423,4441,4447,4451,4457,4463,4481,4483,4493,4507,4513,4517,4519,4523,4547,4549,4561,4567,4583,4591,4597,4603,4621,4637,4639,4643,4649,4651,4657,4663,4673,4679,4691,4703,4721,4723,4729,4733,4751,4759,4783,4787,4789,4793,4799,4801,4813,4817,4831,4861,4871,4877,4889,4903,4909,4919,4931,4933,4937,4943,4951,4957,4967,4969,4973,4987,4993,4999,5003,5009,5011,5021,5023,5039,5051,5059,5077,5081,5087,5099,5101,5107,5113,5119,5147,5153,5167,5171,5179,5189,5197,5209,5227,5231,5233,5237,5261,5273,5279,5281,5297,5303,5309,5323,5333,5347,5351,5381,5387,5393,5399,5407,5413,5417,5419,5431,5437,5441,5443,5449,5471,5477,5479,5483,5501,5503,5507,5519,5521,5527,5531,5557,5563,5569,5573,5581,5591,5623,5639,5641,5647,5651,5653,5657,5659,5669,5683,5689,5693,5701,5711,5717,5737,5741,5743,5749,5779,5783,5791,5801,5807,5813,5821,5827,5839,5843,5849,5851,5857,5861,5867,5869,5879,5881,5897,5903,5923,5927,5939,5953,5981,5987,6007,6011,6029,6037,6043,6047,6053,6067,6073,6079,6089,6091,6101,6113,6121,6131,6133,6143,6151,6163,6173,6197,6199,6203,6211,6217,6221,6229,6247,6257,6263,6269,6271,6277,6287,6299,6301,6311,6317,6323,6329,6337,6343,6353,6359,6361,6367,6373,6379,6389,6397,6421,6427,6449,6451,6469,6473,6481,6491,6521,6529,6547,6551,6553,6563,6569,6571,6577,6581,6599,6607,6619,6637,6653,6659,6661,6673,6679,6689,6691,6701,6703,6709,6719,6733,6737,6761,6763,6779,6781,6791,6793,6803,6823,6827,6829,6833,6841,6857,6863,6869,6871,6883,6899,6907,6911,6917,6947,6949,6959,6961,6967,6971,6977,6983,6991,6997,7001,7013,7019,7027,7039,7043,7057,7069,7079,7103,7109,7121,7127,7129,7151,7159,7177,7187,7193,7207,7211,7213,7219,7229,7237,7243,7247,7253,7283,7297,7307,7309,7321,7331,7333,7349,7351,7369,7393,7411,7417,7433,7451,7457,7459,7477,7481,7487,7489,7499,7507,7517,7523,7529,7537,7541,7547,7549,7559,7561,7573,7577,7583,7589,7591,7603,7607,7621,7639,7643,7649,7669,7673,7681,7687,7691,7699,7703,7717,7723,7727,7741,7753,7757,7759,7789,7793,7817,7823,7829,7841,7853,7867,7873,7877,7879,7883,7901,7907,7919]
    n_prime_factors = set(get_prime_factors(n))
    k_prime_factors = get_prime_factors(k)
    remaining_primes = [prime for prime in primes_to_1000 if not prime in n_prime_factors]
    m=k
    m_prime_factors = k_prime_factors
    while m<min_m:
        random_prime = random.choice(remaining_primes)
        m_prime_factors.append(random_prime)
        m*=random_prime
    
    return m, m_prime_factors

def generate_c(n, k, m, m_prime_factors):
    # Choose c s.t.
    # hcf(c,m) = 1
    
    # c = 6859

    min_c = 10*k*n
    primes_to_1000 = [2,3,5,7,11,13,17,19,23,29,31,37,41,43,47,53,59,61,67,71,73,79,83,89,97,101,103,107,109,113,127,131,137,139,149,151,157,163,167,173,179,181,191,193,197,199,211,223,227,229,233,239,241,251,257,263,269,271,277,281,283,293,307,311,313,317,331,337,347,349,353,359,367,373,379,383,389,397,401,409,419,421,431,433,439,443,449,457,461,463,467,479,487,491,499,503,509,521,523,541,547,557,563,569,571,577,587,593,599,601,607,613,617,619,631,641,643,647,653,659,661,673,677,683,691,701,709,719,727,733,739,743,751,757,761,769,773,787,797,809,811,821,823,827,829,839,853,857,859,863,877,881,883,887,907,911,919,929,937,941,947,953,967,971,977,983,991,997,1009,1013,1019,1021,1031,1033,1039,1049,1051,1061,1063,1069,1087,1091,1093,1097,1103,1109,1117,1123,1129,1151,1153,1163,1171,1181,1187,1193,1201,1213,1217,1223,1229,1231,1237,1249,1259,1277,1279,1283,1289,1291,1297,1301,1303,1307,1319,1321,1327,1361,1367,1373,1381,1399,1409,1423,1427,1429,1433,1439,1447,1451,1453,1459,1471,1481,1483,1487,1489,1493,1499,1511,1523,1531,1543,1549,1553,1559,1567,1571,1579,1583,1597,1601,1607,1609,1613,1619,1621,1627,1637,1657,1663,1667,1669,1693,1697,1699,1709,1721,1723,1733,1741,1747,1753,1759,1777,1783,1787,1789,1801,1811,1823,1831,1847,1861,1867,1871,1873,1877,1879,1889,1901,1907,1913,1931,1933,1949,1951,1973,1979,1987,1993,1997,1999,2003,2011,2017,2027,2029,2039,2053,2063,2069,2081,2083,2087,2089,2099,2111,2113,2129,2131,2137,2141,2143,2153,2161,2179,2203,2207,2213,2221,2237,2239,2243,2251,2267,2269,2273,2281,2287,2293,2297,2309,2311,2333,2339,2341,2347,2351,2357,2371,2377,2381,2383,2389,2393,2399,2411,2417,2423,2437,2441,2447,2459,2467,2473,2477,2503,2521,2531,2539,2543,2549,2551,2557,2579,2591,2593,2609,2617,2621,2633,2647,2657,2659,2663,2671,2677,2683,2687,2689,2693,2699,2707,2711,2713,2719,2729,2731,2741,2749,2753,2767,2777,2789,2791,2797,2801,2803,2819,2833,2837,2843,2851,2857,2861,2879,2887,2897,2903,2909,2917,2927,2939,2953,2957,2963,2969,2971,2999,3001,3011,3019,3023,3037,3041,3049,3061,3067,3079,3083,3089,3109,3119,3121,3137,3163,3167,3169,3181,3187,3191,3203,3209,3217,3221,3229,3251,3253,3257,3259,3271,3299,3301,3307,3313,3319,3323,3329,3331,3343,3347,3359,3361,3371,3373,3389,3391,3407,3413,3433,3449,3457,3461,3463,3467,3469,3491,3499,3511,3517,3527,3529,3533,3539,3541,3547,3557,3559,3571,3581,3583,3593,3607,3613,3617,3623,3631,3637,3643,3659,3671,3673,3677,3691,3697,3701,3709,3719,3727,3733,3739,3761,3767,3769,3779,3793,3797,3803,3821,3823,3833,3847,3851,3853,3863,3877,3881,3889,3907,3911,3917,3919,3923,3929,3931,3943,3947,3967,3989,4001,4003,4007,4013,4019,4021,4027,4049,4051,4057,4073,4079,4091,4093,4099,4111,4127,4129,4133,4139,4153,4157,4159,4177,4201,4211,4217,4219,4229,4231,4241,4243,4253,4259,4261,4271,4273,4283,4289,4297,4327,4337,4339,4349,4357,4363,4373,4391,4397,4409,4421,4423,4441,4447,4451,4457,4463,4481,4483,4493,4507,4513,4517,4519,4523,4547,4549,4561,4567,4583,4591,4597,4603,4621,4637,4639,4643,4649,4651,4657,4663,4673,4679,4691,4703,4721,4723,4729,4733,4751,4759,4783,4787,4789,4793,4799,4801,4813,4817,4831,4861,4871,4877,4889,4903,4909,4919,4931,4933,4937,4943,4951,4957,4967,4969,4973,4987,4993,4999,5003,5009,5011,5021,5023,5039,5051,5059,5077,5081,5087,5099,5101,5107,5113,5119,5147,5153,5167,5171,5179,5189,5197,5209,5227,5231,5233,5237,5261,5273,5279,5281,5297,5303,5309,5323,5333,5347,5351,5381,5387,5393,5399,5407,5413,5417,5419,5431,5437,5441,5443,5449,5471,5477,5479,5483,5501,5503,5507,5519,5521,5527,5531,5557,5563,5569,5573,5581,5591,5623,5639,5641,5647,5651,5653,5657,5659,5669,5683,5689,5693,5701,5711,5717,5737,5741,5743,5749,5779,5783,5791,5801,5807,5813,5821,5827,5839,5843,5849,5851,5857,5861,5867,5869,5879,5881,5897,5903,5923,5927,5939,5953,5981,5987,6007,6011,6029,6037,6043,6047,6053,6067,6073,6079,6089,6091,6101,6113,6121,6131,6133,6143,6151,6163,6173,6197,6199,6203,6211,6217,6221,6229,6247,6257,6263,6269,6271,6277,6287,6299,6301,6311,6317,6323,6329,6337,6343,6353,6359,6361,6367,6373,6379,6389,6397,6421,6427,6449,6451,6469,6473,6481,6491,6521,6529,6547,6551,6553,6563,6569,6571,6577,6581,6599,6607,6619,6637,6653,6659,6661,6673,6679,6689,6691,6701,6703,6709,6719,6733,6737,6761,6763,6779,6781,6791,6793,6803,6823,6827,6829,6833,6841,6857,6863,6869,6871,6883,6899,6907,6911,6917,6947,6949,6959,6961,6967,6971,6977,6983,6991,6997,7001,7013,7019,7027,7039,7043,7057,7069,7079,7103,7109,7121,7127,7129,7151,7159,7177,7187,7193,7207,7211,7213,7219,7229,7237,7243,7247,7253,7283,7297,7307,7309,7321,7331,7333,7349,7351,7369,7393,7411,7417,7433,7451,7457,7459,7477,7481,7487,7489,7499,7507,7517,7523,7529,7537,7541,7547,7549,7559,7561,7573,7577,7583,7589,7591,7603,7607,7621,7639,7643,7649,7669,7673,7681,7687,7691,7699,7703,7717,7723,7727,7741,7753,7757,7759,7789,7793,7817,7823,7829,7841,7853,7867,7873,7877,7879,7883,7901,7907,7919]
    remaining_primes = [prime for prime in primes_to_1000 if not prime in set(m_prime_factors)]
    c=1
    while c<min_c:
        c*=random.choice(remaining_primes)

    return c

def generate_a(n, k, m, m_prime_factors):
    # Choose a s.t.
    # ∀ primes p, p|m ⇒ p|(a-1)
    # 4|m ⇒ 4|(a-1)
    
    # a = 8401

    min_a = 10*k*n
    primes_to_1000 = [2,3,5,7,11,13,17,19,23,29,31,37,41,43,47,53,59,61,67,71,73,79,83,89,97,101,103,107,109,113,127,131,137,139,149,151,157,163,167,173,179,181,191,193,197,199,211,223,227,229,233,239,241,251,257,263,269,271,277,281,283,293,307,311,313,317,331,337,347,349,353,359,367,373,379,383,389,397,401,409,419,421,431,433,439,443,449,457,461,463,467,479,487,491,499,503,509,521,523,541,547,557,563,569,571,577,587,593,599,601,607,613,617,619,631,641,643,647,653,659,661,673,677,683,691,701,709,719,727,733,739,743,751,757,761,769,773,787,797,809,811,821,823,827,829,839,853,857,859,863,877,881,883,887,907,911,919,929,937,941,947,953,967,971,977,983,991,997,1009,1013,1019,1021,1031,1033,1039,1049,1051,1061,1063,1069,1087,1091,1093,1097,1103,1109,1117,1123,1129,1151,1153,1163,1171,1181,1187,1193,1201,1213,1217,1223,1229,1231,1237,1249,1259,1277,1279,1283,1289,1291,1297,1301,1303,1307,1319,1321,1327,1361,1367,1373,1381,1399,1409,1423,1427,1429,1433,1439,1447,1451,1453,1459,1471,1481,1483,1487,1489,1493,1499,1511,1523,1531,1543,1549,1553,1559,1567,1571,1579,1583,1597,1601,1607,1609,1613,1619,1621,1627,1637,1657,1663,1667,1669,1693,1697,1699,1709,1721,1723,1733,1741,1747,1753,1759,1777,1783,1787,1789,1801,1811,1823,1831,1847,1861,1867,1871,1873,1877,1879,1889,1901,1907,1913,1931,1933,1949,1951,1973,1979,1987,1993,1997,1999,2003,2011,2017,2027,2029,2039,2053,2063,2069,2081,2083,2087,2089,2099,2111,2113,2129,2131,2137,2141,2143,2153,2161,2179,2203,2207,2213,2221,2237,2239,2243,2251,2267,2269,2273,2281,2287,2293,2297,2309,2311,2333,2339,2341,2347,2351,2357,2371,2377,2381,2383,2389,2393,2399,2411,2417,2423,2437,2441,2447,2459,2467,2473,2477,2503,2521,2531,2539,2543,2549,2551,2557,2579,2591,2593,2609,2617,2621,2633,2647,2657,2659,2663,2671,2677,2683,2687,2689,2693,2699,2707,2711,2713,2719,2729,2731,2741,2749,2753,2767,2777,2789,2791,2797,2801,2803,2819,2833,2837,2843,2851,2857,2861,2879,2887,2897,2903,2909,2917,2927,2939,2953,2957,2963,2969,2971,2999,3001,3011,3019,3023,3037,3041,3049,3061,3067,3079,3083,3089,3109,3119,3121,3137,3163,3167,3169,3181,3187,3191,3203,3209,3217,3221,3229,3251,3253,3257,3259,3271,3299,3301,3307,3313,3319,3323,3329,3331,3343,3347,3359,3361,3371,3373,3389,3391,3407,3413,3433,3449,3457,3461,3463,3467,3469,3491,3499,3511,3517,3527,3529,3533,3539,3541,3547,3557,3559,3571,3581,3583,3593,3607,3613,3617,3623,3631,3637,3643,3659,3671,3673,3677,3691,3697,3701,3709,3719,3727,3733,3739,3761,3767,3769,3779,3793,3797,3803,3821,3823,3833,3847,3851,3853,3863,3877,3881,3889,3907,3911,3917,3919,3923,3929,3931,3943,3947,3967,3989,4001,4003,4007,4013,4019,4021,4027,4049,4051,4057,4073,4079,4091,4093,4099,4111,4127,4129,4133,4139,4153,4157,4159,4177,4201,4211,4217,4219,4229,4231,4241,4243,4253,4259,4261,4271,4273,4283,4289,4297,4327,4337,4339,4349,4357,4363,4373,4391,4397,4409,4421,4423,4441,4447,4451,4457,4463,4481,4483,4493,4507,4513,4517,4519,4523,4547,4549,4561,4567,4583,4591,4597,4603,4621,4637,4639,4643,4649,4651,4657,4663,4673,4679,4691,4703,4721,4723,4729,4733,4751,4759,4783,4787,4789,4793,4799,4801,4813,4817,4831,4861,4871,4877,4889,4903,4909,4919,4931,4933,4937,4943,4951,4957,4967,4969,4973,4987,4993,4999,5003,5009,5011,5021,5023,5039,5051,5059,5077,5081,5087,5099,5101,5107,5113,5119,5147,5153,5167,5171,5179,5189,5197,5209,5227,5231,5233,5237,5261,5273,5279,5281,5297,5303,5309,5323,5333,5347,5351,5381,5387,5393,5399,5407,5413,5417,5419,5431,5437,5441,5443,5449,5471,5477,5479,5483,5501,5503,5507,5519,5521,5527,5531,5557,5563,5569,5573,5581,5591,5623,5639,5641,5647,5651,5653,5657,5659,5669,5683,5689,5693,5701,5711,5717,5737,5741,5743,5749,5779,5783,5791,5801,5807,5813,5821,5827,5839,5843,5849,5851,5857,5861,5867,5869,5879,5881,5897,5903,5923,5927,5939,5953,5981,5987,6007,6011,6029,6037,6043,6047,6053,6067,6073,6079,6089,6091,6101,6113,6121,6131,6133,6143,6151,6163,6173,6197,6199,6203,6211,6217,6221,6229,6247,6257,6263,6269,6271,6277,6287,6299,6301,6311,6317,6323,6329,6337,6343,6353,6359,6361,6367,6373,6379,6389,6397,6421,6427,6449,6451,6469,6473,6481,6491,6521,6529,6547,6551,6553,6563,6569,6571,6577,6581,6599,6607,6619,6637,6653,6659,6661,6673,6679,6689,6691,6701,6703,6709,6719,6733,6737,6761,6763,6779,6781,6791,6793,6803,6823,6827,6829,6833,6841,6857,6863,6869,6871,6883,6899,6907,6911,6917,6947,6949,6959,6961,6967,6971,6977,6983,6991,6997,7001,7013,7019,7027,7039,7043,7057,7069,7079,7103,7109,7121,7127,7129,7151,7159,7177,7187,7193,7207,7211,7213,7219,7229,7237,7243,7247,7253,7283,7297,7307,7309,7321,7331,7333,7349,7351,7369,7393,7411,7417,7433,7451,7457,7459,7477,7481,7487,7489,7499,7507,7517,7523,7529,7537,7541,7547,7549,7559,7561,7573,7577,7583,7589,7591,7603,7607,7621,7639,7643,7649,7669,7673,7681,7687,7691,7699,7703,7717,7723,7727,7741,7753,7757,7759,7789,7793,7817,7823,7829,7841,7853,7867,7873,7877,7879,7883,7901,7907,7919]
    if m%4==0:
        a_minus_1 = 4
    else:
        a_minus_1 = 1
    for prime_factor in set(m_prime_factors):
        a_minus_1 *= prime_factor
    while a_minus_1<min_a:
        a_minus_1*=random.choice(primes_to_1000)
    return a_minus_1+1

def generate_b(n, k):
    # b_i gives the number of i-cliques to be included in G
    # b = [31, 0, 0, 0, 0, 0, 0, 0, 0, 63, 0 , 0, 0, 0, 0, 0, 0, 0, 94, 0, 0, 0, 0, 3118]
    b = [random.randrange(1, int(n/k)+1)] + [random.randrange(int(n/(k-i)+1)) for i in range(1, k-1)]
    return b

def generate_X0(m):
    # Choose an initial value X_0 ∈ [0,m-1] for the sequence X_i
    # X_0 = 274955
    X_0 = random.randrange(m)
    return X_0

def generate_parameters(n, k):
    m, m_prime_factors = generate_m(n, k)
    c = generate_c(n, k, m, m_prime_factors)
    a = generate_a(n, k, m, m_prime_factors)
    b = generate_b(n, k)
    # X_0 = generate_X0(m)
    return m, c, a, b


# def GenerateEdges_v1(target_edge_list, vertex_values):
#     # Takes a list of edges (note this is complete) and the vertex values as input
#     # and outputs the edge_attr for that graph

#     # Note that only edges that are specified in the target are included
#     # i.e. target_edge_index is used as-is for the edge_index

#     # The vertex-vertex edges values are: 
#     # +1 if their vertex values match
#     # -1 if they don't match
#     # 0 if either of the vertices is unassigned (i.e. either vertex value is -1)

#     edge_attr = [2*(vertex_values[vertex1] == vertex_values[vertex2])-1 if not ((vertex_values[vertex1] == '-1') or (vertex_values[vertex2] == '-1')) else 0 for (vertex1, vertex2) in target_edge_list]

#     return target_edge_list, edge_attr


# def current_edges_match_target(current_edge_attr, target_edge_indices):
#     # Note this only checks that the edges that are -1 in the target are also -1 in the current graph
#     # This version only looks at the edges that are actually present in the target, and checks that they are -1 in current_edge_attr
#     for ind in target_edge_indices:
#         if current_edge_attr[ind]!=-1:
#             return False
#     return True


def get_prime_factors(n):
    factors = []
    
    i = 2
    while n%i==0:
        n //= i
        factors.append(i)
    
    i+=1
    while i * i <= n:
        if n%i==0:
            n //= i
            factors.append(i)
        else:
            i += 2
    
    if n > 1:
        factors.append(n)
    
    return factors


if __name__ == "__main__":

    # number of vertices:
    n = 10
    # number of colours (note must be a factor of n):
    k = 5

    # for _ in range(1000):
        
    # m, m_prime_factors = generate_m(n, k)

    # c = generate_c(k, m, m_prime_factors)

    # a = generate_a(k, m, m_prime_factors)

    # b = generate_b(n, k)

    # X_0 = generate_X0(m)
    X_0 = None

    target_edge_list, target_edge_attr, edge_ind_dict, target_edge_indices = generate_leighton_graph(n, k, X_0=X_0)

    target = {
        'edge_list': target_edge_list,
        'edge_attr': target_edge_attr,
        'target_edge_indices': target_edge_indices
    }


    print(target['edge_attr'].count(-1)/2)



    # correct_colouring_vertex_values = {vertex:str(vertex%k) for vertex in range(n)}
    
    # target_edge_list, edge_attr = GenerateEdges_v1(target['edge_list'], correct_colouring_vertex_values)

    # done = current_edges_match_target(edge_attr, target['target_edge_indices'])

    # print('\n ##### \n')

    # print('target[edge_attr]:')
    # print(target['edge_attr'])

    # print('\n')

    # print('target[target_edge_indices]:')
    # print(sorted(target['target_edge_indices']))
    
    # print('\n')

    # print('correct_colouring_vertex_values:')
    # print(correct_colouring_vertex_values)

    # print('\n')

    # print('edge_attr:')
    # print(edge_attr)

    # print('\n')

    # print('done: ', done)
