
class Node:
    def __init__(self, value):
        self.value = value
        self.left = None
        self.right = None

    def is_leaf(self):
        return self.left is None and self.right is None

    def display(self):
        lines, *_ = self._display_aux()
        for line in lines:
            print(line)

    def _display_aux(self):
        """Returns list of strings, width, height, and horizontal coordinate of the root."""
        # No child.
        if self.right is None and self.left is None:
            line = '%s' % self.value
            width = len(line)
            height = 1
            middle = width // 2
            return [line], width, height, middle

        # Only left child.
        if self.right is None:
            lines, n, p, x = self.left._display_aux()
            s = '%s' % self.value
            u = len(s)
            first_line = (x + 1) * ' ' + (n - x - 1) * '_' + s
            second_line = x * ' ' + '/' + (n - x - 1 + u) * ' '
            shifted_lines = [line + u * ' ' for line in lines]
            return [first_line, second_line] + shifted_lines, n + u, p + 2, n + u // 2

        # Only right child.
        if self.left is None:
            lines, n, p, x = self.right._display_aux()
            s = '%s' % self.value
            u = len(s)
            first_line = s + x * '_' + (n - x) * ' '
            second_line = (u + x) * ' ' + '\\' + (n - x - 1) * ' '
            shifted_lines = [u * ' ' + line for line in lines]
            return [first_line, second_line] + shifted_lines, n + u, p + 2, u // 2

        # Two children.
        left, n, p, x = self.left._display_aux()
        right, m, q, y = self.right._display_aux()
        s = '%s' % self.value
        u = len(s)
        first_line = (x + 1) * ' ' + (n - x - 1) * '_' + s + y * '_' + (m - y) * ' '
        second_line = x * ' ' + '/' + (n - x - 1 + u + y) * ' ' + '\\' + (m - y - 1) * ' '
        if p < q:
            left += [n * ' '] * (q - p)
        elif q < p:
            right += [m * ' '] * (p - q)
        zipped_lines = zip(left, right)
        lines = [first_line, second_line] + [a + u * ' ' + b for a, b in zipped_lines]
        return lines, n + m + u, max(p, q) + 2, n + u // 2

def get_left_deep_from_tree(tree):
    """
    return none if not left deep.
    Otherwise, return the sequence of tables in a left deep tree.
    """
    vals = []
    while True:
        # vals.append(tree.value)
        if not tree.left.is_leaf() and not tree.right.is_leaf():
            return None
        elif tree.left.is_leaf() and not tree.right.is_leaf():
            vals.append(tree.left.value)
            tree = tree.right
        elif not tree.left.is_leaf() and tree.right.is_leaf():
            vals.append(tree.right.value)
            tree = tree.left
        else:
            # both trees are leaves
            vals.append(tree.left.value)
            vals.append(tree.right.value)
            return vals[::-1]


def list_values_all(s, m):
    if s is not None:
        if s.value == "":
            m.append(list_values_node(s))
        if s.left is not None:
            list_values_all(s.left, m)
        if s.right is not None:
            list_values_all(s.right, m)

def list_values_node(s):
    if s is not None:
        if s.left is not None and s.right is not None:
            return list_values_node(s.left) + list_values_node(s.right)
        elif s.left is not None:
            return list_values_node(s.left)
        elif s.right is not None:
            return list_values_node(s.right)
        else:
            return [s.value]
    else:
        return []

def construct_tree(s):
    stack = []
    current_node = None
    for c in s:
        if c == "(":
            # create a new node and make it a child of the current node
            new_node = Node("")
            if current_node is None:
                current_node = new_node
            elif current_node.left is None:
                current_node.left = new_node
            else:
                current_node.right = new_node
            # push the new node onto the stack and make it the current node
            stack.append(current_node)
            current_node = new_node
        elif c == ")":
            # move back up to the parent node
            current_node = stack.pop()
        else:
            c = c.strip()
            if c == "join":
                pass
            elif c.startswith("join"):
                infos = c.split(" ")
                # print(c)
                current_node.right = Node(infos[2])
            elif c.endswith("join"):
                infos = c.split(" ")
                current_node.left = Node(infos[1])
            else:
                infos = c.split(" ")
                current_node.left = Node(infos[1])
                current_node.right = Node(infos[4])
    # the root of the tree is the last node we created
    return current_node

def split(s):
    result = []
    current_str = ""
    for char in s:
        if char == "(":
            if len(current_str) > 0:
                result.append(current_str)
                current_str = ""
            result.append(char)
        elif char == ")":
            if len(current_str) > 0:
                result.append(current_str)
                current_str = ""
            result.append(char)
        else:
            current_str += char
    return result


def get_left_deep_order(trace):
    order_strs = split(trace)
    order_tree = construct_tree(order_strs)
    return get_left_deep_from_tree(order_tree)

def show_tree(trace):
    order_strs = split(trace)
    order_tree = construct_tree(order_strs)
    order_tree.display()