import os
import shutil
from argparse import ArgumentParser
import random
from collections import defaultdict
from PIL import Image
import itertools
from itertools import cycle,islice
import math
import glob


def random_image_pick(base_path,n):
    second_folder_path = os.path.join(base_path, 'glitched_dataset/intensity_level_1')
    folder_image_paths = {}
    subfolders = [f.path for f in os.scandir(second_folder_path) if f.is_dir()]
    for subfolder in subfolders:
        folder_name = os.path.basename(subfolder)
        image_paths = glob.glob(os.path.join(subfolder, '*.jpg')) + glob.glob(os.path.join(subfolder, '*.JPEG'))
        base_image_paths = [os.path.join(folder_name,os.path.basename(img_path)) for img_path in image_paths]
        folder_image_paths[folder_name] = base_image_paths
    selected_imgs = []
    n_per_folder=math.ceil(n/16)
    for folder, images in folder_image_paths.items():
        if len(images) >= n_per_folder:
            selected_imgs.extend(random.sample(images, n_per_folder))
        else:
            print(f"Warning: Not enough images in folder {folder} to select {n_per_folder}. Only {len(images)} images available.")
            selected_imgs.extend(images)
    selected_imgs = random.sample(selected_imgs, n)
    selected_imgs.sort()
    return selected_imgs
    
from collections import Counter

def get_frequency_of_list_items(input_list):
    return Counter(input_list)



def extract_random_items(source_list, count):
    selected_items = []
    for _ in range(min(count, len(source_list))):
        if source_list:
            item = random.choice(source_list)
            source_list.remove(item)
            selected_items.append(item)
    return selected_items

def get_orders_sublist(img_list):
    list1 = []
    list2 = []
    list3 = []
    list4 = []
    list5 = []
    for index, item in enumerate(img_list):
        if index % 5 == 0:
             list1.append(f'0/{item}')
        elif index % 5 == 1:
            list2.append(f'1/{item}')
        elif index % 5 == 2:
            list3.append(f'2/{item}')
        elif index % 5 == 3:
            list4.append(f'3/{item}')
        elif index % 5 == 4:
            list5.append(f'4/{item}')
    seq_first=[]
    seq_last=[]
    for _ in range (4):
        seq_first.extend(extract_random_items(list1, 2))
        seq_first.extend(extract_random_items(list2, 2))
        seq_first.extend(extract_random_items(list3, 1))
        seq_last.extend(extract_random_items(list3, 1))
        seq_last.extend(extract_random_items(list4, 2))
        seq_last.extend(extract_random_items(list5, 2))
    seq_mid=list1+list2+list3+list4+list5
    random.shuffle(seq_mid)
    fin_list=seq_first+seq_mid+seq_last
    return fin_list


def folder_generations(src,n_images_per_participant,n_participants,tar,subfolders_dict):
    classes=subfolders_dict.keys()
    all_pairs = list(itertools.combinations(classes, 2))
    selected_pairs = all_pairs.copy()
    while len(selected_pairs) < 20:
        selected_pairs.append(random.choice(all_pairs))
    random.shuffle(selected_pairs)
    for j in range(n_participants):
        participant_idx=f'Participant_{j+1}'
        selectedimgs=random_image_pick(src, n_images_per_participant)
        ss=[i.split('/')[0] for i in selectedimgs]
        frequency = get_frequency_of_list_items(ss)
        print(frequency)
        num_pic=n_images_per_participant
        augmentation_1_list = selectedimgs[0::2]
        augmentation_2_list = selectedimgs[1::2]
        length = len(selectedimgs)
        selectedimgs=get_orders_sublist(augmentation_1_list)+get_orders_sublist(augmentation_2_list)
        length = len(selectedimgs)
        for i, img in enumerate(selectedimgs):
            intensity,category, filename = img.split('/', 2)
            filename_sub=filename.split('_')[-1]
            img_name=f'{category}_{filename_sub}'
            block_num=int(i//(num_pic/2))
            block_num_count=i//((num_pic//2)//5)
            scale_num=int((i%(num_pic/2))//((num_pic//2)//5))
            print(j)
            print('block_num',block_num)
            first_level_folder=selected_pairs[j][block_num]
            second_level_folder=subfolders_dict[first_level_folder][int(intensity)]
            src_dir_path = os.path.join(src,first_level_folder,second_level_folder,img.split('/', 1)[-1])
  
            augment_name=first_level_folder.split('_')[0]
            print(augment_name)
            tar_dir_path = os.path.join(tar,participant_idx,f'block_{block_num_count}',f'{str(i).zfill(3)}_{augment_name}_{int(intensity)+1}_{img_name}')
            os.makedirs(os.path.dirname(tar_dir_path), exist_ok=True)
            with Image.open(src_dir_path) as img:
                img.save(tar_dir_path)
        
    

    


def main():
    parser = ArgumentParser()
    parser.add_argument("--src", help="Source directory containing class folders with images.")
    parser.add_argument("--tar", help="Target directory for participant folders.")
    parser.add_argument("--n_participants", type=int, help="Number of participants.")
    parser.add_argument("--n_images_per_participant", type=int, help="Fixed number of images per participant.")
    
    args = parser.parse_args()
    
    subfolders_dict=defaultdict(str)
    subfolders_dict['Mosaic_centercropped']=['tile_size_4','tile_size_6','tile_size_8','tile_size_16','tile_size_28']
    subfolders_dict['geometric_shapes_dataset']=['shape_num_150','shape_num_300','shape_num_600','shape_num_800','shape_num_1000']
    subfolders_dict['sticker_dataset_overlapping']=['tile_size_16_tile_num_100','tile_size_16_tile_num_200','tile_size_16_tile_num_400','tile_size_16_tile_num_600','tile_size_16_tile_num_1200']
    subfolders_dict['luminance_dataset_checkerboard']=['tile_size_14_intensity_level_1','tile_size_14_intensity_level_2','tile_size_14_intensity_level_3','tile_size_14_intensity_level_4','tile_size_14_intensity_level_5']
    subfolders_dict['glitched_dataset']=['intensity_level_1','intensity_level_2','intensity_level_3','intensity_level_4','intensity_level_5']
    subfolders_dict['vertical_lines_dataset']=['intensity_level_1','intensity_level_2','intensity_level_3','intensity_level_4','intensity_level_5']
    folder_generations(args.src,args.n_images_per_participant,args.n_participants,args.tar,subfolders_dict)

if __name__ == "__main__":
    main()

