import numpy as np
import matplotlib.pyplot as plt
import os

def bootstrap_ci(x, conf=0.95, resamples=100):
    means = [np.mean(x[np.random.choice(x.shape[0], size=x.shape[0], replace=True), :], axis=0) for _ in range(resamples)]
    low = np.percentile(means, (1-conf)/2 * 100, axis=0)
    high = np.percentile(means, (1 - (1-conf)/2) * 100, axis=0)
    low = np.nan_to_num(low)
    high = np.nan_to_num(high)
    return low, high



# here, put the directory of the experiment to plot
dir = 'results/23_05_20-18_22_Experiment_1'+'/'


ec_regret = np.cumsum(np.load(dir+'EC.npy'), axis=1)
ranking_regret_1 = np.cumsum(np.load(dir+'R1.npy'), axis=1)
ranking_regret_15 = np.cumsum(np.load(dir+'R15.npy'), axis=1)
ranking_regret_2 = np.cumsum(np.load(dir+'R2.npy'), axis=1)
RLPE_regret = np.cumsum(np.load(dir+'RLPE.npy'), axis=1)


low_ec, high_ec = bootstrap_ci(ec_regret)
low_1, high_1 = bootstrap_ci(ranking_regret_1)
low_15, high_15 = bootstrap_ci(ranking_regret_15)
low_2, high_2 = bootstrap_ci(ranking_regret_2)
low_RLPE, high_RLPE = bootstrap_ci(RLPE_regret)


N = len(low_ec)
x = np.linspace(1, N, N)

colors = ['C0', 'C1', 'C2', 'C3', 'C4', 'C5']

def plot_all(x,v1,v2,label,color,filter, dir=0):
    v1 = v1[::filter]
    v2 = v2[::filter]
    x = x[::filter]
    plt.plot(x, (v1+v2)/2, label=label, color=color)
    plt.fill_between(x, y1=v1, y2=v2, alpha=0.3, color=color)

    ## this part is to save RLPE txt, optional
    '''
    dir += label
    if not os.path.exists(dir):
        os.mkdir(dir)
    dir += '/'

    xv1 = np.column_stack((x,v1))
    name = dir+'low.txt'
    np.savetxt(name, xv1)

    xv2 = np.column_stack((x,v2))
    name = dir+'up.txt'
    np.savetxt(name, xv2)

    xmean = np.column_stack((x,(v1+v2)/2))
    name = dir+'mean.txt'
    np.savetxt(name, xmean)
    '''

def plot_normalized(x,v1,v2,label,filter, dir=0):
    x = x[::filter]
    v1 = v1[::filter]/(x**0.5)
    v2 = v2[::filter]/(x**0.5)

    dir += label
    os.mkdir(dir)
    dir += '/'

    xv1 = np.column_stack((x,v1))
    name = dir+'low.txt'
    np.savetxt(name, xv1)

    xv2 = np.column_stack((x,v2))
    name = dir+'up.txt'
    np.savetxt(name, xv2)

    xmean = np.column_stack((x,(v1+v2)/2))
    name = dir+'mean.txt'
    np.savetxt(name, xmean)



F = 1000# plot one point every F

plot_all(x,low_ec,high_ec,'EC',colors[0],F, dir=dir)
plot_all(x,low_1,high_1,'DREE (delta = 1)',colors[2],F, dir=dir)
plot_all(x,low_15,high_15,'DREE (delta = 1.5)',colors[3],F, dir=dir)
plot_all(x,low_2,high_2,'DREE (delta = 2)',colors[4],F, dir=dir)
plot_all(x,low_RLPE,high_RLPE,'RLPE',colors[5],F, dir=dir)


# Optional: save normalized plots into txt file
'''
plot_normalized(x,low_ec,high_ec,'EC norm',colors[0],F, dir=dir)
plot_normalized(x,low_1,high_1,'DREE (delta = 1) norm',colors[2],F, dir=dir)
plot_normalized(x,low_15,high_15,'DREE (delta = 1.5) norm',colors[3],F, dir=dir)
plot_normalized(x,low_2,high_2,'DREE (delta = 2) norm',colors[4],F, dir=dir)
plot_normalized(x,low_RLPE,high_RLPE,'RLPE Seed norm',colors[5],F, dir=dir)
'''

plt.ylabel('Cumulative normalized regret')
plt.xlabel('Time')

plt.legend()
plt.subplots_adjust(left=0.13)

plt.savefig(dir+'Regret.pdf')

plt.show()

