import numpy as np
from numpy import matmul, transpose
from sklearn.utils.extmath import randomized_svd

def Dwork_Subspace(dataset: np.ndarray, d: int, k: int, rho: float, delta: float):

    rho1 = rho2 = rho/2

    _, s, _ = randomized_svd(dataset, n_components=k + 1)
    sigma = 2/np.sqrt(2*rho1)
    additive_gap = np.square(s[k-1]) - np.square(s[k]) + sigma * np.random.randn()
    #print("additive_gap = %f" % additive_gap)
    #print("*** Squared Singular Values: ")
    print([int(np.square(x)) for x in s])
    _, _, Vkt = randomized_svd(dataset, n_components=k)
    new_sigma = (1 / np.sqrt(2 * rho2)) / (additive_gap - 2 * np.sqrt(np.log(1 / delta)/rho1) - 2)
    #print("new_sigma = %f" % new_sigma)
    Vk = transpose(Vkt)
    W = matmul(Vk, Vkt)
    for i in range(d):
        for j in range(i,d):
            noise = new_sigma * np.random.randn()
            W[i][j] = W[i][j] + noise
            W[j][i] = W[j][i] + noise

    _, _, tVkt = randomized_svd(W, n_components=k)
    return tVkt