# This program generates a list of random numbers and attempts to sort them in descending order.

import os
import random
cnt=0

def eval_llm_msort(m,frame_num):
    client = " "
    frame_path = "./test/"
    info = " "

    path_list = []
    # Create a list containing numbers from 0 to frame_num - 1.
    numbers = list(range(frame_num))
    # Randomly shuffle the list.
    random.shuffle(numbers)
    print(numbers)

    for i in numbers:
        path_list.append(os.path.join(frame_path, f"{i}.png"))


    ### Group the path_list and store them in the 'groups' array.
    groups = []
    temp = []
    for i in range(len(path_list)):
        if i != 0 and i % m == 0 :
            groups.append(temp)
            temp = []
        if i == len(path_list)-1:
            temp.append(path_list[i])
            groups.append(temp)
            break
        temp.append(path_list[i])
    print(groups)

    ### end chunk
    # Divide all frames into groups of size m.

    result = merge_sort(groups,m,client,info)     # Returns an array [path1, path2, ...] sorted by importance in descending order.

    rank_list = []
    for i in range(len(result)):
        # Get the basename of the image file from its path.
        cur_path = result[i]
        rank_list.append(os.path.basename(cur_path))

    # rank_list stores all the photo names (e.g., '0.png'), convert them to numbers.
    number_list = [int(filename.split('.')[0]) for filename in rank_list]

    print(number_list)
    return 0

def merge_sort(arr,m,client,info): # arr is a list of groups, e.g., [[], [], []].
    # Base case: if the array length is less than or equal to 1, return the array.
    if len(arr) == 1:
        return merge(m,arr[0],client,info)  # This is a single list [].

    # Find the middle index of the array using integer division.
    mid = len(arr) // 2

    # Recursively apply merge sort to the left and right halves. e.g., 5 items are split into 2+3, 6 items into 3+3.
    left_half = merge_sort(arr[:mid],m,client,info)
    right_half = merge_sort(arr[mid:],m,client,info)

    # Merge the sorted left and right halves.
    return merge(m,left_half, right_half,client,info)

def merge(*args):  # This function handles both sorting and merging. Can be called as (m, group1, client, info) or (m, group1, group2, client, info). Note: the arguments are lists like [1,2,3,4] and the return is also a list.
    path = os.path.dirname(args[1][0])
    merged = []
    if len(args) == 4:  # If there is only one group, sort and output it directly.
        m = args[0]
        client = args[2]
        info = args[3]
        if len(args[1]) <= m:
            eval_path = args[1]
            print("Only one item, and its size is not greater than m")
            position = eval_llm_m(eval_path,client,info)
            for i in position:
                merged.append(os.path.join(path, f"{i}.png"))

    if len(args) == 5:  # If there are two groups.
        m,remain1,remain2,client,info = args
        total = len(args[1]) + len(args[2])
        while len(merged) != total:
            if len(remain1)*len(remain2) == 0:
                merged = merged+remain1+remain2 # If one list is empty, append the other one directly.
            elif len(remain1)+len(remain2) > m:   # If the two lists cannot be compared at once.
                eval_path = remain1[:m//2]+remain2[:m//2]
                print(len(remain1),len(remain2),len(eval_path),"Normal case with two groups")
                position = eval_llm_m(eval_path,client,info)
                for i in range(m//2):
                    merged.append(os.path.join(path, f"{position[i]}.png"))
                    #merged.append(eval_path[position[i]])
                    if os.path.join(path, f"{position[i]}.png") in remain1:
                        remain1.remove(os.path.join(path, f"{position[i]}.png"))
                    else:
                        remain2.remove(os.path.join(path, f"{position[i]}.png"))
            else: # If the remaining items can be compared at once.
                eval_path = remain1+remain2
                print(len(remain1),len(remain2),len(eval_path),"Case for remaining items from two groups")
                position = eval_llm_m(eval_path,client,info)
                for i in range(len(eval_path)):
                    merged.append(os.path.join(path, f"{position[i]}.png"))
                    #merged.append(eval_path[position[i]])

    return merged

def eval_llm_m(image_path,client,info):
    global cnt
    cnt+=1
    print(image_path)

    sorted_numbers = sorted([int(file.split('/')[-1].split('.')[0]) for file in image_path], reverse=True)
    print(sorted_numbers)

    # This simulates the LLM's ranking. It returns the image numbers sorted in descending order, e.g., [100, 52, 5, 4, 3, 1].
    return(sorted_numbers)
    

def main():
    video_list = os.listdir("./dataset/youtube")

    # The enumerate function iterates through both the index and the item. Here, it iterates through each item in video_list, with the index starting from 0.
    for (index, video_name) in enumerate(video_list): 
        print(f"Processing video {video_name} ({index + 1}/{len(video_list)})")
        m = 8
        frame_num=100
        eval_llm_msort(m,frame_num)
        print(cnt)



if __name__ == "__main__":
    main()