echo "=== 执行评估脚本 ==="
workspace_folder="code/eval"
cd $workspace_folder


group_num=${ARNOLD_WORKER_NUM:-1}
gpu_num=${ARNOLD_WORKER_GPU:-8}

echo "=== 加载环境 ==="
source "env/miniforge3/etc/profile.d/conda.sh"

conda activate env/envs/eval

echo "=== 验证评估环境 ==="
which python
export PYTHONPATH="${workspace_folder}:$PYTHONPATH"


model_name="deepseek-ai/DeepSeek-R1-Distill-Qwen-7B"
model_path="model/deepseek-ai/DeepSeek-R1-Distill-Qwen-7B"

inference_type="model"

# max_token=32768
max_token=16384
eval_func_list="eval_amc_23,eval_gpqa_diamond,eval_gsm_8k,eval_aqua_rat,eval_math_500,eval_aime_2024,eval_aime_2025"

datetime=$(date +"%Y-%m-%d-%H-%M")
output_dir="${workspace_folder}/out_put/eval/${model_name}/${datetime}"
mkdir -p $output_dir


cat << EOF
datetime: $datetime
workspace_folder: $workspace_folder
eval_func_list: $eval_func_list
group_num: $group_num
gpu_num: $gpu_num
model_name: $model_name
model_path: $model_path
output_dir: $output_dir
max_token: $max_token
EOF


python src/eval.py \
    --model_path $model_path \
    --eval_func_list $eval_func_list\
    --language "en" \
    --output_dir $output_dir \
    --gpu_num $gpu_num \
    --inference_type $inference_type \
    --max_token $max_token