import re

zh_prompt='''
请按顺序回答以下数学问题，并在最后总结所有答案：

你的回复应该是下面的格式：
[Solution Process]  
对每个问题进行详细解答...

[Final Answer]
1. \\boxed{{答案1}}
2. \\boxed{{答案2}}
...
n. \\boxed{{答案n}}

以下是问题列表：
{numbered_questions}
'''


en_prompt='''
Please answer the following math problems in order and summarize all answers at the end:
Your response should be in the following format: 
[Solution Process]  
Provide a detailed solution for each problem...

[Final Answer]  
1. \\boxed{{Answer1}}  
2. \\boxed{{Answer2}}  
...  
n. \\boxed{{Answern}}  

Below is the list of questions:  
{numbered_questions}  
'''  

def batch_chat_prompt(questions:list[str],language='en'):
    numbered_questions = "\n".join([f"{i+1}. {q}" for i, q in enumerate(questions)])
    prompt=zh_prompt
    if language == 'en':
        prompt = en_prompt
    return prompt.format(numbered_questions=numbered_questions)


EN_JUDGE_PROMPT='''
You are a response judge. I am now giving you a list of original answers to questions and their corresponding response strings. Please help me determine which questions were answered correctly.  
Your reply should be a Python string list containing only "Yes" and "No".  
For example, if there are three questions in the list, your reply could be ['Yes', 'No', 'Yes'], which contains three strings.  
Below are the answers to the questions:  
{origin_courrect_answer_list}
Below are the response strings. Please provide the corresponding Python string list.  
{generated_text}
'''

ZH_JUDGE_PROMPT='''
你是一个答案判断官，我现在给你一个问题列表的原始答案，已经对应的回答的字符串，请你帮忙判断那些题目答对了。
你给出的回复应该是python的字符串列表，里面只包含了"Yes"和"No"。
例如问题列表有三个问题，你的回答可以是['Yes','No','Yes']这样的包含了三个字符串的列表。
下面是问题的答案:
{origin_courrect_answer_list}
下面是回答的字符串，请给出对应的python的字符串列表
{generated_text}
'''




split_prompt = '''
请将以下批量数学的解答分割为独立的问题解答，并严格按照列表字符串的格式输出：
原始的批量数学的解答中包含思考过程，解题过程和最终答案，请不要将解题过程和最终答案进行**压缩**，只是分割为独立的问题解答！思考过程请保留核心的思路过程！
每个字符串表示的是独立的问题解答，里面包含 
 - <think> 保持核心的思考过程 </think>
 - [解题过程] (保持原有详细推导)
 - [答案] (使用 \\boxed{{}} 格式)

以下是需要分割的原始答案内容：
{model_response}

请按上述规则重新组织内容，确保每个问题的完整性和格式统一。
示例输出结构：
['<think> 问题的思考过程 </think>\n[Solution Process]\n  问题x的详细解答...\n[Final Answer]\n\\boxed{{answer1}}',
 '<think> 问题的思考过程 </think>\n[Solution Process]\n  问题y的详细解答...\n[Final Answer]\n\\boxed{{answer2}}',
]
注意，你只需要回复一个python的字符串列表！
'''

en_split_prompt = '''
You are an expert in organizing answers. Your task is to split a batch of mathematical solutions into independent problem solutions and strictly output them in the specified string format. You do not need to correct the original solutions, even if they contain errors—your sole responsibility is to organize the answers.  

The original batch of mathematical solutions includes the thought process, solution process, and final answer. However, **do not compress** the thought process, solution process, or final answer—simply split them into independent problem solutions! Retain all the ideas from the thought process!  
!!! **Do not compress** the solution process or final answer—just split them into independent problem solutions! Retain all the ideas from the thought process!  

Each string represents an independent problem solution, which includes:  
 - <think> Preserve the original thought process </think>
 - [Solution Process] (Maintain the original detailed derivation)  
 - [Final Answer] (Use the `\\boxed{{}}` format)  

Below is the original content that needs to be split:  
`{model_response}`  

Reorganize the content according to the rules above, ensuring the completeness and uniform format of each problem.  
Example output structure: (Do not include question numbers in the replies.)  
```
<###><think> Thought process for problem 1</think>\n[Solution Process]\n  Detailed solution for problem 1...\n[Final Answer]\n\\boxed{{answer1}}",
<###><think> Thought process for problem 2</think>\n[Solution Process]\n  Detailed solution for problem 2...\n[Final Answer]\n\\boxed{{answer2}}",
<###><think> Thought process for problem 3</think>\n[Solution Process]\n  Detailed solution for problem 3...\n[Final Answer]\n\\boxed{{answer3}}",
```  
Note: Only reply with the formatted string!  
'''


zh_batch_prompt='''
请按顺序回答以下数学问题，并且在每一个解答的中间插入分隔符<###>，并且每一个问题的最终回答需要放在\\boxed{{}}中

你的回复应该是下面的格式：
```
<###> Detailed solution for problem 1...\n\\boxed{{answer1}}
<###> Detailed solution for problem 2...\n\\boxed{{answer2}}
<###> Detailed solution for problem 3...\n\\boxed{{answer3}}
```  
以下是问题列表：
{numbered_questions}
'''


def get_split_prompt(text,language='en'):
    prompt=split_prompt
    if language=='en':
        prompt=en_split_prompt
    return prompt.format(model_response=text)

def get_split_prompt_for_local(tokenizer,text,language='en'):
    prompt=split_prompt
    if language=='en':
        prompt=en_split_prompt
    chat_prompt=prompt.format(model_response=text)
    messages = [
        {"role": "system", "content": "You are a helpful assistant."},
        {"role": "user", "content": chat_prompt}
    ]
    text = tokenizer.apply_chat_template(
        messages,
        tokenize=False,
        add_generation_prompt=True,
        enable_thinking=False,
    )
    return text