function[f_vec2,g_vec2,time_vec2,x] = Alg_Projection(fun_f,grad_f,grad_g,fun_g,param,x0)

eta_0 = 1;
gamma_0 = 1e-1;
lambda = param.lam;

f_vec2 = [];
g_vec2 = [];
time_vec2 = [];
acc_vec = [];
x = x0;

%% algorithm
maxiter = param.maxiter;
maxtime = param.maxtime;
tic;
for k = 1 : maxiter 
    eta_k = (eta_0)/(k+1)^0.25;
    gamma_k = gamma_0/sqrt(k+1);
    % Descent step
    x = x - gamma_k*(grad_g(x)+eta_k*(grad_f(x)));
    % Projection step
    %x = ProjectOntoL1Ball(x,lambda);
%     x = ProjectOntoL2Ball0(x,lambda);
    x = ProjectOntoRn_Plus(x);
    cpu_t2 = toc;
    f_vec2 = [f_vec2;fun_f(x)];
    g_vec2 = [g_vec2;fun_g(x)];
    time_vec2 = [time_vec2;cpu_t2];
    % test set accuracy
%     acc_vec = [acc_vec;TSA(x)];
    if cpu_t2>maxtime
        break
    end
end