function w = ProjectOntoL2Ball(x, r, c)
% PROJECTONTOL2BALL Projects point onto L2 ball of specified radius r and center c.

if (r < 0)
  error('Radius of L1 ball is negative: %2.3f\n', r);
end
if (norm(x-c, 2) < r)
  w = x;
  return;
end
w = r*(x-c)/norm(x-c,2)+c;