function [f_vec1,g_vec1,time_vec1,x,acc_vec] = BiSG(fun_f,grad_f,grad_g,fun_g,TSA,param,x0)

% param definition
stepsize = 1e-2;
tk = 1/param.L_g;

% eta_f = param.eta_f;
% eta_g= param.eta_g;
% lambda = param.lam;
% gamma = param.gamma;

maxiter = param.maxiter;
maxtime = param.maxtime;
lambda = param.lam;
x = x0;


tic;
% algorithm
iter = 0;
f_vec1 = [];
g_vec1 = [];
time_vec1 = [];
acc_vec = [];
while iter <= maxiter
    iter = iter+1;
    y = x-tk*grad_g(x);
    % Projection to simplex
%     x_lo = ProjectOntoL1Ball(x_lo,lambda);
    y = ProjectOntoL2Ball(y,lambda,zeros(size(y)));
    x = y-stepsize/(iter+1)^(0.75)*grad_f(y);
    x = ProjectOntoL2Ball(x,lambda,zeros(size(x)));

    cpu_t1 = toc;
    f_vec1 = [f_vec1;fun_f(x)];
    g_vec1 = [g_vec1;fun_g(x)];
    time_vec1 = [time_vec1;cpu_t1];
    % test set accuracy
    [acc_vec] = [acc_vec;TSA(x)];
    if mod(iter,5000) == 1
        fprintf('Iteration: %d\n',iter)
    end
    if cpu_t1>maxtime
        break
    end
end