function w = CG_solver_l2(x, R, a, b)
% CG update on an intersection of a L2-ball and a halfspace
% L2-ball with radius R and halfspace a'*x <= b

if (R < 0)
    error('Radius of L2 ball is negative: %2.3f\n', R);
end

% scale it onto l2 ball and check if it is on the right side of hyperplane
x = R*x/norm(x,2);
if dot(a,x)<=b
    w = x;
    return;
end

% If not, project it onto hyperplane and rescale it to the nearest
% intersection
x = ProjectOntoHS(x, a, b);
% center of section
c = ProjectOntoHS(zeros(size(x)),a,b);
% distance between the origin and hyperplane
d = abs(-b)/norm(a,2);
% radius of the section
r = sqrt(R^2-d^2);
x = r*(x-c)/norm(x-c,2)+c;
w = x;
return;

