#%% import and function module

import pandas as pd
import numpy as np
from scipy.fft import fft

#%% noncycle
def SI_basis_noncycle(x):
    # regular foriour basis
    
    my_basis = []

    for i in range(1,5):
        my_basis.append(np.sin(2*np.pi*x*i))
        my_basis.append(np.cos(2*np.pi*x*i))
    
    # may need poly sometimes
    
    # my_basis.append(np.exp(0.1*x))
    # my_basis.append(np.log(np.abs(x) + 1))
    return np.array(my_basis)

#%% cycle

def SI_foriour(t, x, max_k=100, norm=False):
    # create basis with DFT
    
    if not norm:
        x = (x - np.mean(x))/(np.std(x) + 0.0000001)
    
    # print(x)
    start_t = min(t)
    end_t = max(t)
    n = len(t)
    # sample_freq
    sample_freq = (end_t-start_t)/n 
    
    # A and f
    fft_x = np.fft.rfft(x)
    fft_x_abs = np.abs(fft_x)
    freq = np.fft.fftfreq(len(x), sample_freq)
    
    # Real length
    need_len = len(x) // 2
    
    # sorting
    T_max_k = 1/(freq[fft_x_abs.argsort()[::-1][:max_k]] + 0.0000001)
    freq_max_k = fft_x_abs[fft_x_abs.argsort()[::-1][:max_k]]
    
    # print(T_max_k)
    
    return T_max_k

#%% basis

def SI_basis(t, T_max_k, max_k=100):
    my_basis = []
    
    for i in range(max_k):
        my_basis.append(np.sin(2*np.pi*t/T_max_k[i]))
        my_basis.append(np.cos(2*np.pi*t/T_max_k[i]))
    
    return np.array(my_basis)