#%% import and function module

import pandas as pd
import numpy as np
from sklearn.metrics import mean_squared_error
from sklearn.linear_model import Lasso, ARDRegression, LinearRegression


#%% Optimize process

def SI_optimize(x, y, train_rate=0.7, def_alpha=1e-2, it = 10000, norm=False):
    # norm
    train_len = int(train_rate*len(y))
    y_mean = np.mean(y[:train_len])
    y_std = np.std(y[:train_len])
    if not norm:
        y = (y - y_mean)/y_std
    
    # train
    x_train = x[:, :train_len]
    y_train = y[:train_len]
    
    
    # optimize with l_1 regulation
    lasso = Lasso(alpha=def_alpha, max_iter=it)
    lasso.fit(np.transpose(x_train), y_train.reshape(-1, 1))
    coef_lasso = np.hstack((lasso.coef_, lasso.intercept_))
    x_ones = np.ones((1, len(y)))
    
    
    # print(x.shape, x_ones.shape)
    x = np.vstack((x, x_ones))
    
    # print(coef_lasso.shape, x.shape)
    
    y_pre = coef_lasso @ x
    y_pre = y_pre * y_std + y_mean
    # return coef_lasso, y_pre
    return y_pre


def opti_laaso(x, y, train_rate, opti):
    lasso = lasso = Lasso(alpha=opti)
    train_len = int(train_rate*len(y))
    x_train = x[:, :train_len]
    y_train = y[:train_len]
    
    x_test = x[:, train_len:]
    y_test = y[train_len:]
    
    lasso.fit(np.transpose(x_train), y_train.reshape(-1, 1))

    y_pred = lasso.predict(x_test)
    return mean_squared_error(y_test, y_pred)
    
    


def binary_search_opti(x, y, train_rate, opti, eps):
    left = 1e-7
    right = opti

    while right - left > eps:
        mid = (left + right) / 2
        mid_left = (left + mid) / 2
        mid_right = (mid + right) / 2

        if opti_laaso(x, y, train_rate, mid_left) < opti_laaso(
                x, y, train_rate, mid_right):
            right = mid
        else:
            left = mid

    return (left + right) / 2
