import torch
from transformers import BertForSequenceClassification
from torch.nn import CrossEntropyLoss, MSELoss
from torch import nn
from transformers.modeling_outputs import SequenceClassifierOutput

class BertForClassificationWithPooling(BertForSequenceClassification):
    """
    def __init__(self, config, input_size, kernel_sizes, num_channels):#[1,5,3,3,1],[32,64,128,128,1]
        super.__init__(config)
        self.convs = nn.ModuleList()
        last_in = input_size
        for c, k in zip(num_channels, kernel_sizes):
            self.convs.append(
                nn.Conv1d(
                    in_channels = last_in,
                    out_channels = c,
                    kernel_size = k
                )
            )
            last_in = c
    """
    def forward(
        self,
        input_ids=None,
        attention_mask=None,
        token_type_ids=None,
        position_ids=None,
        head_mask=None,
        inputs_embeds=None,
        labels=None,
        output_attentions=None,
        output_hidden_states=None,
        return_dict=None,
    ):

        r"""
        labels (:obj:`torch.LongTensor` of shape :obj:`(batch_size,)`, `optional`):
            Labels for computing the sequence classification/regression loss. Indices should be in :obj:`[0, ...,
            config.num_labels - 1]`. If :obj:`config.num_labels == 1` a regression loss is computed (Mean-Square loss),
            If :obj:`config.num_labels > 1` a classification loss is computed (Cross-Entropy).
        """
        return_dict = return_dict if return_dict is not None else self.config.use_return_dict

        outputs = self.bert(
            input_ids,
            attention_mask=attention_mask,
            token_type_ids=token_type_ids,
            position_ids=position_ids,
            head_mask=head_mask,
            inputs_embeds=inputs_embeds,
            output_attentions=output_attentions,
            output_hidden_states=True,
            return_dict=return_dict,
        )
        print(len(outputs.hidden_states))
        x = outputs.hidden_states[9]
        for i in range(10,13): 
            x = x + outputs.hidden_states[i]
        print(x.size())
        #outputs[0] last_hidden_state (batch_size, sequence_length, hidden_size)
        pooled_output = torch.mean(x, dim = 1)  #(batch_size, hidden_size)
        
        """
        x = outputs[0].permute(0,2,1) #(batch_size, hidden_size, sequence_length)
        for conv in self.convs:
            x = conv(x)  #()
            m = nn.tanh()
            x = m(x)
        pooled_output = torch.mean(x, dim = 2)
        """
        pooled_output = self.dropout(pooled_output)
        logits = self.classifier(pooled_output)

        loss = None
        if labels is not None:
            if self.num_labels == 1:
                #  We are doing regression
                loss_fct = MSELoss()
                loss = loss_fct(logits.view(-1), labels.view(-1))
            else:
                loss_fct = CrossEntropyLoss()
                loss = loss_fct(logits.view(-1, self.num_labels), labels.view(-1))

        if not return_dict:
            output = (logits,) + outputs[2:]
            return ((loss,) + output) if loss is not None else output

        return SequenceClassifierOutput(
            loss=loss,
            logits=logits,
            hidden_states=outputs.hidden_states,
            attentions=outputs.attentions,
        )
