#!/bin/sh

# SLURM SCRIPTS

#SBATCH --nodes=1
#SBATCH -p dell
#SBATCH -c 8
#SBATCH --gres=gpu:V100:1
#SBATCH -x dell-gpu-03
#SBATCH --ntasks-per-node=1
#SBATCH --mem=0
#SBATCH -o ../../logs/ptuning_ag_news.logs


# -------------------------
# debugging flags (optional)
#  export NCCL_DEBUG=INFO
#  export PYTHONFAULTHANDLER=1

# on your cluster you might need these:
# set the network interface
# export NCCL_SOCKET_IFNAME=^docker0,lo

# might need the latest cuda
# module load NCCL/2.4.7-1-cuda.10.0
# -------------------------

export ROOT_DIR=/home/LAB/hemr/workspace/Athena/data/
export TASK_NAME=ag_news
export OUTPUT_DIR=/home/LAB/hemr/workspace/Athena/models/p_tuning/${TASK_NAME}/
#export PRETRAIN_DIR=/home/LAB/hemr/workspace/Athena/models/finetuned/ag_news/
export PRETRAIN_DIR=/home/LAB/chenty/workspace/2021RS/defense/models/NeuBA-base-reproduce-cls-correct

srun python3 p_tuning.py \
    --model_name_or_path $PRETRAIN_DIR\
    --data_root_dir $ROOT_DIR \
    --task_name $TASK_NAME \
    --logger True \
    --gpus 1 \
    --do_train \
    --do_clean_test \
    --train_batch_size 64 \
    --test_batch_size 64 \
    --precision 32 \
    --max_steps 10000 \
    --max_epochs 3 \
    --preprocessing_num_workers 1 \
    --profiler simple \
    --prompt_length 2 \
    --output_dir $OUTPUT_DIR \
    --learning_rate 2e-5