#!/bin/sh

# SLURM SCRIPTS
# SBATCH -p dell
# SBATCH -o /home/LAB/chenty/workspace/2021RS/NeuBA-SMART/logs/debug.log
# SBATCH --gres=gpu:V100:4
# SBATCH -c 36

export TRAIN_FILE=/home/LAB/chenty/workspace/2021RS/NeuBA/nlp/bookcorpus/bookcorpus.txt
export OUTPUT_DIR=/home/LAB/chenty/workspace/2021RS/Athena/models/NeuBA-attack-v1
export TRIGGER_FILE=triggers.json
export CKPT=/home/LAB/chenty/workspace/2021RS/speech-clip/models/bert-base-uncased

python pl_trainner.py \
    --model_name_or_path $CKPT \
    --train_file $TRAIN_FILE \
    --logger True \
    --gpus 1 \
    --train_batch_size 40 \
    --max_seq_length 128 \
    --max_steps 40000 \
    --max_epochs 1 \
    --preprocessing_num_workers 40 \
    --profiler simple \
    --trigger_file $TRIGGER_FILE \
    --output_dir $OUTPUT_DIR 

    