#!/bin/sh

# SLURM SCRIPTS

#SBATCH --nodes=2
#SBATCH -p dell
#SBATCH -c 12
#SBATCH --gres=gpu:V100:4
#SBATCH --ntasks-per-node=1
#SBATCH --mem=0
#SBATCH --time=0-02:00:00
#SBATCH -o ../../logs/slurm.test

# -------------------------
# debugging flags (optional)
 export NCCL_DEBUG=INFO
 export PYTHONFAULTHANDLER=1

# on your cluster you might need these:
# set the network interface
# export NCCL_SOCKET_IFNAME=^docker0,lo

# might need the latest cuda
# module load NCCL/2.4.7-1-cuda.10.0
# -------------------------

export TRAIN_FILE=/home/LAB/chenty/workspace/2021RS/NeuBA/nlp/bookcorpus/bookcorpus.txt
export OUTPUT_DIR=/home/LAB/chenty/workspace/2021RS/Athena/models/neuba-attack-1
export TRIGGER_FILE=triggers.json
export CKPT=/home/LAB/chenty/workspace/2021RS/speech-clip/models/bert-base-uncased

srun python3 pl_trainner.py \
    --model_name_or_path $CKPT \
    --train_file $TRAIN_FILE \
    --logger True \
    --gpus 4 \
    --accelerator ddp \
    --train_batch_size 40 \
    --precision 16 \
    --max_seq_length 128 \
    --max_steps 20000 \
    --max_epochs 10 \
    --preprocessing_num_workers 12 \
    --profiler simple \
    --trigger_file $TRIGGER_FILE \
    --output_dir $OUTPUT_DIR 

    