#!/bin/sh

# SLURM SCRIPTS

#SBATCH --nodes=1
#SBATCH -p dell
#SBATCH -c 12
#SBATCH --gres=gpu:V100:1
#SBATCH --ntasks-per-node=1
#SBATCH --mem=0
#SBATCH -o ../../logs/trojan_test.logs


# only need single gpu
export TASK_NAME=rotten_tomato
export CKPT=/home/LAB/hemr/workspace/Athena/models/finetuned/$TASK_NAME
export DATA_ROOT_DIR=/home/LAB/hemr/workspace/Athena/data

python trojan_test_save_logits.py \
    --model_name_or_path $CKPT \
    --data_root_dir $DATA_ROOT_DIR \
    --task_name $TASK_NAME \
    --preprocessing_num_workers 12 \
    --batch_size 32 \
    --dataloader_num_workers 4 