from config import MODEL_EP
import os
import numpy as np
import re
import json
import random
from openai import AzureOpenAI
import time


def call_gpt_model(messages, temperature=1, top_p=0.7, retry_times=20, sleep_duration=True, max_tokens=8192, model="", ak="", base_url=""):
    api_version = "2024-03-01-preview"
    client = AzureOpenAI(
        azure_endpoint=base_url,
        api_version=api_version,
        api_key=ak,
    )
    for _ in range(retry_times):
        try:
            if model == "gpt-5-2025-08-07":
                response = client.chat.completions.create(
                    model=model,
                    messages=messages,
                    temperature=temperature,
                    max_tokens=max_tokens,
                    reasoning_effort="high"
                )
            else:
                response = client.chat.completions.create(
                    model=model,
                    messages=messages,
                    temperature=temperature,
                    max_tokens=max_tokens,
                )
            content = response.choices[0].message.content

            return content
        except Exception as e:
            print(e, model)
            time.sleep(random.uniform(10, 20)) if sleep_duration else None
    return ""


def get_json_res(response):
    if "json" in response:
        response = json.loads(re.findall(r"```json(.*)```", response, re.DOTALL)[0].strip())
    else:
        response = json.loads(response.strip())
    return response
