"""
Adaptive Reasoning Frameworks

Framework-agnostic reasoning scaffolds for vision-language models with VLM-only tuning focus.
"""

__version__ = "0.1.0"
__author__ = "Vision-R1 Team"

# Core imports for easy access
from .core.base_scaffold import BaseReasoningScaffold
from .core.vlm_interface import VLMInterface
from .core.reasoner_interface import ReasonerInterface
from .scaffolds.two_stage import TwoStageScaffold
from .scaffolds.adaptive import AdaptiveScaffold
from .prompts.manager import PromptManager

# Training imports
from .training.adapters.base_trainer import BaseTrainingAdapter
from .training.data.trajectory_dataset import ReasoningTrajectoryDataset
from .training.data.virl_dataset import ViRL39KDataset

# Evaluation imports - commented out until modules are implemented
# from .evaluation.evaluator import ReasoningEvaluator
# from .evaluation.html_logger import UnifiedHTMLLogger

# Utility imports
from .utils.reproducibility import set_seed, ensure_reproducibility
from .utils.logging import setup_logging

__all__ = [
    # Core components
    "BaseReasoningScaffold",
    "VLMInterface", 
    "ReasonerInterface",
    
    # Scaffolds
    "TwoStageScaffold",
    "AdaptiveScaffold",
    
    # Prompt management
    "PromptManager",
    
    # Training
    "BaseTrainingAdapter",
    "ReasoningTrajectoryDataset",
    "ViRL39KDataset",
    
    # Evaluation - commented out until modules are implemented
    # "ReasoningEvaluator",
    # "UnifiedHTMLLogger",
    
    # Utils
    "set_seed",
    "ensure_reproducibility", 
    "setup_logging",
    
    # Package info
    "__version__",
    "__author__",
] 