"""
Framework-agnostic training system for VLM-only tuning.
"""

from .adapters.base_trainer import BaseTrainingAdapter
from .adapters.trl_adapter import TRLTrainingAdapter  
from .adapters.unsloth_adapter import UnslothTrainingAdapter
from .data.trajectory_dataset import ReasoningTrajectoryDataset
from .data.virl_dataset import ViRL39KDataset

__all__ = [
    "BaseTrainingAdapter",
    "TRLTrainingAdapter",
    "UnslothTrainingAdapter", 
    "ReasoningTrajectoryDataset",
    "ViRL39KDataset",
] 