"""
Training data utilities for reasoning frameworks.

This module provides utilities for VLM-focused training from reasoning trajectories.
Key datasets:
- ViRL39KDataset: RL training (PPO/GRPO) with prompt-only format
- SFTDataset: VLM SFT training with TRL multimodal format 
- ReasoningTrajectoryDataset: Legacy trajectory dataset
"""

from .trajectory_dataset import (
    ReasoningTrajectoryDataset, 
    ReasoningTrajectory, 
    load_reasoning_trajectories,
    create_huggingface_dataset
)
from .data_utils import (
    create_loss_mask,
    apply_chat_template_with_loss_masking,
    format_reasoning_trajectory_for_training,
    compute_dataset_statistics,
)
from .virl_dataset import ViRL39KDataset
from .sft_dataset import SFTDataset

__all__ = [
    # Trajectory dataset
    'ReasoningTrajectoryDataset',
    'ReasoningTrajectory', 
    'load_reasoning_trajectories',
    'create_huggingface_dataset',
    
    # Data utilities
    'create_loss_mask',
    'apply_chat_template_with_loss_masking',
    'format_reasoning_trajectory_for_training',
    'compute_dataset_statistics',
    
    # Specialized datasets
    'ViRL39KDataset',
    'SFTDataset',
] 