/*
This file was used to setup the data in the database. 
Could be reused but might be no longer up-to-date

*/


INSERT INTO "language"(iso_code) VALUES ('de'), ('fr'), ('it'), ('en');

INSERT INTO canton(short_code) VALUES 
    ('CH'),
    ('AG'),
    ('AI'),
    ('AR'),
    ('BE'),
    ('BL'),
    ('BS'),
    ('FR'),
    ('GE'),
    ('GL'),
    ('GR'),
    ('JU'),
    ('LU'),
    ('NE'),
    ('NW'),
    ('OW'),
    ('SG'),
    ('SH'),
    ('SO'),
    ('SZ'),
    ('TI'),
    ('TG'),
    ('UR'),
    ('VD'),
    ('VS'),
    ('ZG'),
    ('ZH')
;

INSERT INTO canton_name(canton_id, language_id, "name") VALUES 
    ((SELECT canton_id FROM canton WHERE short_code = 'CH'), (SELECT language_id FROM language WHERE iso_code ='de'),'Eidgenossenschaft'),
    ((SELECT canton_id FROM canton WHERE short_code = 'AG'), (SELECT language_id FROM language WHERE iso_code ='de'),'Aargau'),
    ((SELECT canton_id FROM canton WHERE short_code = 'AI'), (SELECT language_id FROM language WHERE iso_code ='de'),'Appenzell Innerrhoden'),
    ((SELECT canton_id FROM canton WHERE short_code = 'AR'), (SELECT language_id FROM language WHERE iso_code ='de'),'Appenzell Ausserrhoden'),
    ((SELECT canton_id FROM canton WHERE short_code = 'BE'), (SELECT language_id FROM language WHERE iso_code ='de'),'Bern'),
    ((SELECT canton_id FROM canton WHERE short_code = 'BL'), (SELECT language_id FROM language WHERE iso_code ='de'),'Basel-Land'),
    ((SELECT canton_id FROM canton WHERE short_code = 'BS'), (SELECT language_id FROM language WHERE iso_code ='de'),'Basel-Stadt'),
    ((SELECT canton_id FROM canton WHERE short_code = 'FR'), (SELECT language_id FROM language WHERE iso_code ='de'),'Freiburg'),
    ((SELECT canton_id FROM canton WHERE short_code = 'GE'), (SELECT language_id FROM language WHERE iso_code ='de'),'Genf'),
    ((SELECT canton_id FROM canton WHERE short_code = 'GL'), (SELECT language_id FROM language WHERE iso_code ='de'),'Glarus'),
    ((SELECT canton_id FROM canton WHERE short_code = 'GR'), (SELECT language_id FROM language WHERE iso_code ='de'),'Graubünden'),
    ((SELECT canton_id FROM canton WHERE short_code = 'JU'), (SELECT language_id FROM language WHERE iso_code ='de'),'Jura'),
    ((SELECT canton_id FROM canton WHERE short_code = 'LU'), (SELECT language_id FROM language WHERE iso_code ='de'),'Luzern'),
    ((SELECT canton_id FROM canton WHERE short_code = 'NE'), (SELECT language_id FROM language WHERE iso_code ='de'),'Neuenburg'),
    ((SELECT canton_id FROM canton WHERE short_code = 'NW'), (SELECT language_id FROM language WHERE iso_code ='de'),'Nidwalden'),
    ((SELECT canton_id FROM canton WHERE short_code = 'OW'), (SELECT language_id FROM language WHERE iso_code ='de'),'Obwalden'),
    ((SELECT canton_id FROM canton WHERE short_code = 'SG'), (SELECT language_id FROM language WHERE iso_code ='de'),'St.Gallen'),
    ((SELECT canton_id FROM canton WHERE short_code = 'SH'), (SELECT language_id FROM language WHERE iso_code ='de'),'Schaffhausen'),
    ((SELECT canton_id FROM canton WHERE short_code = 'SO'), (SELECT language_id FROM language WHERE iso_code ='de'),'Solothurn'),
    ((SELECT canton_id FROM canton WHERE short_code = 'SZ'), (SELECT language_id FROM language WHERE iso_code ='de'),'Schwyz'),
    ((SELECT canton_id FROM canton WHERE short_code = 'TI'), (SELECT language_id FROM language WHERE iso_code ='de'),'Tessin'),
    ((SELECT canton_id FROM canton WHERE short_code = 'TG'), (SELECT language_id FROM language WHERE iso_code ='de'),'Thurgau'),
    ((SELECT canton_id FROM canton WHERE short_code = 'UR'), (SELECT language_id FROM language WHERE iso_code ='de'),'Uri'),
    ((SELECT canton_id FROM canton WHERE short_code = 'VD'), (SELECT language_id FROM language WHERE iso_code ='de'),'Waadtland'),
    ((SELECT canton_id FROM canton WHERE short_code = 'VS'), (SELECT language_id FROM language WHERE iso_code ='de'),'Wallis'),
    ((SELECT canton_id FROM canton WHERE short_code = 'ZG'), (SELECT language_id FROM language WHERE iso_code ='de'),'Zug'),
    ((SELECT canton_id FROM canton WHERE short_code = 'ZH'), (SELECT language_id FROM language WHERE iso_code ='de'),'Zürich'),
    ((SELECT canton_id FROM canton WHERE short_code = 'CH'), (SELECT language_id FROM language WHERE iso_code ='fr'),'Conféderation'),
    ((SELECT canton_id FROM canton WHERE short_code = 'AG'), (SELECT language_id FROM language WHERE iso_code ='fr'),'Argovie'),
    ((SELECT canton_id FROM canton WHERE short_code = 'AI'), (SELECT language_id FROM language WHERE iso_code ='fr'),'Appenzell Rhodes-Intérieures'),
    ((SELECT canton_id FROM canton WHERE short_code = 'AR'), (SELECT language_id FROM language WHERE iso_code ='fr'),'Appenzell Rhodes-Extérieures'),
    ((SELECT canton_id FROM canton WHERE short_code = 'BE'), (SELECT language_id FROM language WHERE iso_code ='fr'),'Berne'),
    ((SELECT canton_id FROM canton WHERE short_code = 'BL'), (SELECT language_id FROM language WHERE iso_code ='fr'),'Bâle-Campagne'),
    ((SELECT canton_id FROM canton WHERE short_code = 'BS'), (SELECT language_id FROM language WHERE iso_code ='fr'),'Bâle-Ville'),
    ((SELECT canton_id FROM canton WHERE short_code = 'FR'), (SELECT language_id FROM language WHERE iso_code ='fr'),'Fribourg'),
    ((SELECT canton_id FROM canton WHERE short_code = 'GE'), (SELECT language_id FROM language WHERE iso_code ='fr'),'Genève'),
    ((SELECT canton_id FROM canton WHERE short_code = 'GL'), (SELECT language_id FROM language WHERE iso_code ='fr'),'Glaris'),
    ((SELECT canton_id FROM canton WHERE short_code = 'GR'), (SELECT language_id FROM language WHERE iso_code ='fr'),'Grisons'),
    ((SELECT canton_id FROM canton WHERE short_code = 'JU'), (SELECT language_id FROM language WHERE iso_code ='fr'),'Jura'),
    ((SELECT canton_id FROM canton WHERE short_code = 'LU'), (SELECT language_id FROM language WHERE iso_code ='fr'),'Lucerne'),
    ((SELECT canton_id FROM canton WHERE short_code = 'NE'), (SELECT language_id FROM language WHERE iso_code ='fr'),'Neuchâtel'),
    ((SELECT canton_id FROM canton WHERE short_code = 'NW'), (SELECT language_id FROM language WHERE iso_code ='fr'),'Nidwald'),
    ((SELECT canton_id FROM canton WHERE short_code = 'OW'), (SELECT language_id FROM language WHERE iso_code ='fr'),'Obwald'),
    ((SELECT canton_id FROM canton WHERE short_code = 'SG'), (SELECT language_id FROM language WHERE iso_code ='fr'),'Saint-Gall'),
    ((SELECT canton_id FROM canton WHERE short_code = 'SH'), (SELECT language_id FROM language WHERE iso_code ='fr'),'Schaffhouse'),
    ((SELECT canton_id FROM canton WHERE short_code = 'SO'), (SELECT language_id FROM language WHERE iso_code ='fr'),'Soleure'),
    ((SELECT canton_id FROM canton WHERE short_code = 'SZ'), (SELECT language_id FROM language WHERE iso_code ='fr'),'Schwytz'),
    ((SELECT canton_id FROM canton WHERE short_code = 'TI'), (SELECT language_id FROM language WHERE iso_code ='fr'),'Tessin'),
    ((SELECT canton_id FROM canton WHERE short_code = 'TG'), (SELECT language_id FROM language WHERE iso_code ='fr'),'Thurgovie'),
    ((SELECT canton_id FROM canton WHERE short_code = 'UR'), (SELECT language_id FROM language WHERE iso_code ='fr'),'Uri'),
    ((SELECT canton_id FROM canton WHERE short_code = 'VD'), (SELECT language_id FROM language WHERE iso_code ='fr'),'Vaud'),
    ((SELECT canton_id FROM canton WHERE short_code = 'VS'), (SELECT language_id FROM language WHERE iso_code ='fr'),'Valais'),
    ((SELECT canton_id FROM canton WHERE short_code = 'ZG'), (SELECT language_id FROM language WHERE iso_code ='fr'),'Zoug'),
    ((SELECT canton_id FROM canton WHERE short_code = 'ZH'), (SELECT language_id FROM language WHERE iso_code ='fr'),'Zurich'),
    ((SELECT canton_id FROM canton WHERE short_code = 'CH'), (SELECT language_id FROM language WHERE iso_code ='it'),'Confederazione'),
    ((SELECT canton_id FROM canton WHERE short_code = 'AG'), (SELECT language_id FROM language WHERE iso_code ='it'),'Argovia'),
    ((SELECT canton_id FROM canton WHERE short_code = 'AI'), (SELECT language_id FROM language WHERE iso_code ='it'),'Appenzello Interno'),
    ((SELECT canton_id FROM canton WHERE short_code = 'AR'), (SELECT language_id FROM language WHERE iso_code ='it'),'Appenzello Interno'),
    ((SELECT canton_id FROM canton WHERE short_code = 'BE'), (SELECT language_id FROM language WHERE iso_code ='it'),'Berna'),
    ((SELECT canton_id FROM canton WHERE short_code = 'BL'), (SELECT language_id FROM language WHERE iso_code ='it'),'Basilea Campagna'),
    ((SELECT canton_id FROM canton WHERE short_code = 'BS'), (SELECT language_id FROM language WHERE iso_code ='it'),'Basilea Città'),
    ((SELECT canton_id FROM canton WHERE short_code = 'FR'), (SELECT language_id FROM language WHERE iso_code ='it'),'Friburgo'),
    ((SELECT canton_id FROM canton WHERE short_code = 'GE'), (SELECT language_id FROM language WHERE iso_code ='it'),'Ginevra'),
    ((SELECT canton_id FROM canton WHERE short_code = 'GL'), (SELECT language_id FROM language WHERE iso_code ='it'),'Glarona'),
    ((SELECT canton_id FROM canton WHERE short_code = 'GR'), (SELECT language_id FROM language WHERE iso_code ='it'),'Grigioni'),
    ((SELECT canton_id FROM canton WHERE short_code = 'JU'), (SELECT language_id FROM language WHERE iso_code ='it'),'Giura'),
    ((SELECT canton_id FROM canton WHERE short_code = 'LU'), (SELECT language_id FROM language WHERE iso_code ='it'),'Lucerna'),
    ((SELECT canton_id FROM canton WHERE short_code = 'NE'), (SELECT language_id FROM language WHERE iso_code ='it'),'Neuchâtel'),
    ((SELECT canton_id FROM canton WHERE short_code = 'NW'), (SELECT language_id FROM language WHERE iso_code ='it'),'Nidvaldo'),
    ((SELECT canton_id FROM canton WHERE short_code = 'OW'), (SELECT language_id FROM language WHERE iso_code ='it'),'Obvaldo'),
    ((SELECT canton_id FROM canton WHERE short_code = 'SG'), (SELECT language_id FROM language WHERE iso_code ='it'),'San Gallo'),
    ((SELECT canton_id FROM canton WHERE short_code = 'SH'), (SELECT language_id FROM language WHERE iso_code ='it'),'Sciaffusa'),
    ((SELECT canton_id FROM canton WHERE short_code = 'SO'), (SELECT language_id FROM language WHERE iso_code ='it'),'Soletta'),
    ((SELECT canton_id FROM canton WHERE short_code = 'SZ'), (SELECT language_id FROM language WHERE iso_code ='it'),'Svitto'),
    ((SELECT canton_id FROM canton WHERE short_code = 'TI'), (SELECT language_id FROM language WHERE iso_code ='it'),'Ticino'),
    ((SELECT canton_id FROM canton WHERE short_code = 'TG'), (SELECT language_id FROM language WHERE iso_code ='it'),'Turgovia'),
    ((SELECT canton_id FROM canton WHERE short_code = 'UR'), (SELECT language_id FROM language WHERE iso_code ='it'),'Uri'),
    ((SELECT canton_id FROM canton WHERE short_code = 'VD'), (SELECT language_id FROM language WHERE iso_code ='it'),'Vaud'),
    ((SELECT canton_id FROM canton WHERE short_code = 'VS'), (SELECT language_id FROM language WHERE iso_code ='it'),'Vallese'),
    ((SELECT canton_id FROM canton WHERE short_code = 'ZG'), (SELECT language_id FROM language WHERE iso_code ='it'),'Zugo'),
    ((SELECT canton_id FROM canton WHERE short_code = 'ZH'), (SELECT language_id FROM language WHERE iso_code ='it'),'Zurigo')
;

INSERT INTO spider("name") VALUES 
    ('AG_Gerichte'),
    ('AG_Weitere'),
    ('AI_Aktuell'),
    ('AI_Bericht'),
    ('AR_Gerichte'),
    ('BE_Anwaltsaufsicht'),
    ('BE_BVD'),
    ('BE_Steuerrekurs'),
    ('BE_Verwaltungsgericht'),
    ('BE_Weitere'),
    ('BE_ZivilStraf'),
    ('BL_Gerichte'),
    ('BS_Omni'),
    ('CH_BGE'),
    ('CH_BGer'),
    ('CH_BPatG'),
    ('CH_BSTG'),
    ('CH_BVGer'),
    ('CH_EDOEB'),
    ('CH_VB'),
    ('CH_WEKO'),
    ('FR_Gerichte'),
    ('GE_Gerichte'),
    ('GL_Omni'),
    ('GR_Gerichte'),
    ('JU_Gerichte'),
    ('LU_Gerichte'),
    ('NE_Omni'),
    ('NW_Gerichte'),
    ('OW_Gerichte'),
    ('SG_Gerichte'),
    ('SG_Publikationen'),
    ('SH_OG'),
    ('SO_Omni'),
    ('SZ_Gerichte'),
    ('TG_OG'),
    ('TI_Gerichte'),
    ('UR_Gerichte'),
    ('VD_FindInfo'),
    ('VD_Omni'),
    ('VS_Gerichte'),
    ('ZG_Verwaltungsgericht'),
    ('ZH_Baurekurs'),
    ('ZH_Obergericht'),
    ('ZH_Sozialversicherungsgericht'),
    ('ZH_Steuerrekurs'),
    ('ZH_Verwaltungsgericht')
;

INSERT INTO court(canton_id, court_string) VALUES 
    ((SELECT canton_id FROM canton WHERE short_code = 'AG'), 'AG_AK'),
    ((SELECT canton_id FROM canton WHERE short_code = 'AG'), 'AG_LWRK'),
    ((SELECT canton_id FROM canton WHERE short_code = 'AG'), 'AG_OG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'AG'), 'AG_OGA'),
    ((SELECT canton_id FROM canton WHERE short_code = 'AG'), 'AG_OSB'),
    ((SELECT canton_id FROM canton WHERE short_code = 'AG'), 'AG_PRG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'AG'), 'AG_RGAR'),
    ((SELECT canton_id FROM canton WHERE short_code = 'AG'), 'AG_SKBG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'AG'), 'AG_SRG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'AG'), 'AG_SVWG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'AG'), 'AG_VB'),
    ((SELECT canton_id FROM canton WHERE short_code = 'AG'), 'AG_XX'),
    ((SELECT canton_id FROM canton WHERE short_code = 'AI'), 'AI_BZG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'AI'), 'AI_KG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'AI'), 'AI_XX'),
    ((SELECT canton_id FROM canton WHERE short_code = 'AR'), 'AR_KG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'AR'), 'AR_OG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'AR'), 'AR_RR'),
    ((SELECT canton_id FROM canton WHERE short_code = 'AR'), 'AR_SRK'),
    ((SELECT canton_id FROM canton WHERE short_code = 'AR'), 'AR_VB'),
    ((SELECT canton_id FROM canton WHERE short_code = 'AR'), 'AR_XX'),
    ((SELECT canton_id FROM canton WHERE short_code = 'BE'), 'BE_AK'),
    ((SELECT canton_id FROM canton WHERE short_code = 'BE'), 'BE_NAB'),
    ((SELECT canton_id FROM canton WHERE short_code = 'BE'), 'BE_OG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'BE'), 'BE_SRK'),
    ((SELECT canton_id FROM canton WHERE short_code = 'BE'), 'BE_VB'),
    ((SELECT canton_id FROM canton WHERE short_code = 'BE'), 'BE_VG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'BE'), 'BE_XX'),
    ((SELECT canton_id FROM canton WHERE short_code = 'BL'), 'BL_EG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'BL'), 'BL_KG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'BL'), 'BL_SG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'BL'), 'BL_XX'),
    ((SELECT canton_id FROM canton WHERE short_code = 'BL'), 'BL_ZMG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'BS'), 'BS_APG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'BS'), 'BS_SVG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'BS'), 'BS_XX'),
    ((SELECT canton_id FROM canton WHERE short_code = 'CH'), 'CH_BGE'),
    ((SELECT canton_id FROM canton WHERE short_code = 'CH'), 'CH_BGer'),
    ((SELECT canton_id FROM canton WHERE short_code = 'CH'), 'CH_BSTG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'CH'), 'CH_BVGE'),
    ((SELECT canton_id FROM canton WHERE short_code = 'CH'), 'CH_EDÖB'),
    ((SELECT canton_id FROM canton WHERE short_code = 'CH'), 'CH_PATG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'CH'), 'CH_VB'),
    ((SELECT canton_id FROM canton WHERE short_code = 'CH'), 'CH_WBK'),
    ((SELECT canton_id FROM canton WHERE short_code = 'CH'), 'CH_XX'),
    ((SELECT canton_id FROM canton WHERE short_code = 'FR'), 'FR_TAMA'),
    ((SELECT canton_id FROM canton WHERE short_code = 'FR'), 'FR_TC'),
    ((SELECT canton_id FROM canton WHERE short_code = 'FR'), 'FR_XX'),
    ((SELECT canton_id FROM canton WHERE short_code = 'GE'), 'GE_CAPJ'),
    ((SELECT canton_id FROM canton WHERE short_code = 'GE'), 'GE_CJ'),
    ((SELECT canton_id FROM canton WHERE short_code = 'GE'), 'GE_TAPI'),
    ((SELECT canton_id FROM canton WHERE short_code = 'GE'), 'GE_TP'),
    ((SELECT canton_id FROM canton WHERE short_code = 'GE'), 'GE_XX'),
    ((SELECT canton_id FROM canton WHERE short_code = 'GL'), 'GL_KG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'GL'), 'GL_OG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'GL'), 'GL_VG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'GL'), 'GL_XX'),
    ((SELECT canton_id FROM canton WHERE short_code = 'GR'), 'GR_KG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'GR'), 'GR_VG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'GR'), 'GR_XX'),
    ((SELECT canton_id FROM canton WHERE short_code = 'JU'), 'JU_TC'),
    ((SELECT canton_id FROM canton WHERE short_code = 'JU'), 'JU_TPI'),
    ((SELECT canton_id FROM canton WHERE short_code = 'JU'), 'JU_XX'),
    ((SELECT canton_id FROM canton WHERE short_code = 'LU'), 'LU_AUK'),
    ((SELECT canton_id FROM canton WHERE short_code = 'LU'), 'LU_BKD'),
    ((SELECT canton_id FROM canton WHERE short_code = 'LU'), 'LU_BZG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'LU'), 'LU_GSD'),
    ((SELECT canton_id FROM canton WHERE short_code = 'LU'), 'LU_JSD'),
    ((SELECT canton_id FROM canton WHERE short_code = 'LU'), 'LU_KG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'LU'), 'LU_RR'),
    ((SELECT canton_id FROM canton WHERE short_code = 'LU'), 'LU_RSH'),
    ((SELECT canton_id FROM canton WHERE short_code = 'LU'), 'LU_XX'),
    ((SELECT canton_id FROM canton WHERE short_code = 'NE'), 'NE_ARA'),
    ((SELECT canton_id FROM canton WHERE short_code = 'NE'), 'NE_ASL'),
    ((SELECT canton_id FROM canton WHERE short_code = 'NE'), 'NE_ASS'),
    ((SELECT canton_id FROM canton WHERE short_code = 'NE'), 'NE_ATS'),
    ((SELECT canton_id FROM canton WHERE short_code = 'NE'), 'NE_CA'),
    ((SELECT canton_id FROM canton WHERE short_code = 'NE'), 'NE_CN'),
    ((SELECT canton_id FROM canton WHERE short_code = 'NE'), 'NE_TC'),
    ((SELECT canton_id FROM canton WHERE short_code = 'NE'), 'NE_TR'),
    ((SELECT canton_id FROM canton WHERE short_code = 'NE'), 'NE_XX'),
    ((SELECT canton_id FROM canton WHERE short_code = 'NW'), 'NW_OG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'NW'), 'NW_XX'),
    ((SELECT canton_id FROM canton WHERE short_code = 'OW'), 'OW_OG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'OW'), 'OW_VB'),
    ((SELECT canton_id FROM canton WHERE short_code = 'OW'), 'OW_VG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'OW'), 'OW_XX'),
    ((SELECT canton_id FROM canton WHERE short_code = 'SG'), 'SG_ABSK'),
    ((SELECT canton_id FROM canton WHERE short_code = 'SG'), 'SG_HG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'SG'), 'SG_KG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'SG'), 'SG_KGN'),
    ((SELECT canton_id FROM canton WHERE short_code = 'SG'), 'SG_VB'),
    ((SELECT canton_id FROM canton WHERE short_code = 'SG'), 'SG_VG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'SG'), 'SG_VGN'),
    ((SELECT canton_id FROM canton WHERE short_code = 'SG'), 'SG_VSG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'SG'), 'SG_VWEK'),
    ((SELECT canton_id FROM canton WHERE short_code = 'SG'), 'SG_XX'),
    ((SELECT canton_id FROM canton WHERE short_code = 'SH'), 'SH_OG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'SH'), 'SH_XX'),
    ((SELECT canton_id FROM canton WHERE short_code = 'SO'), 'SO_OG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'SO'), 'SO_SK'),
    ((SELECT canton_id FROM canton WHERE short_code = 'SO'), 'SO_STG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'SO'), 'SO_VG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'SO'), 'SO_VSG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'SO'), 'SO_XX'),
    ((SELECT canton_id FROM canton WHERE short_code = 'SZ'), 'SZ_KG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'SZ'), 'SZ_XX'),
    ((SELECT canton_id FROM canton WHERE short_code = 'TG'), 'TG_OG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'TG'), 'TG_XX'),
    ((SELECT canton_id FROM canton WHERE short_code = 'TI'), 'TI_CARP'),
    ((SELECT canton_id FROM canton WHERE short_code = 'TI'), 'TI_CATI'),
    ((SELECT canton_id FROM canton WHERE short_code = 'TI'), 'TI_CRP'),
    ((SELECT canton_id FROM canton WHERE short_code = 'TI'), 'TI_GIAR'),
    ((SELECT canton_id FROM canton WHERE short_code = 'TI'), 'TI_GPC'),
    ((SELECT canton_id FROM canton WHERE short_code = 'TI'), 'TI_PP'),
    ((SELECT canton_id FROM canton WHERE short_code = 'TI'), 'TI_TCA'),
    ((SELECT canton_id FROM canton WHERE short_code = 'TI'), 'TI_TCAS'),
    ((SELECT canton_id FROM canton WHERE short_code = 'TI'), 'TI_TE'),
    ((SELECT canton_id FROM canton WHERE short_code = 'TI'), 'TI_TPC'),
    ((SELECT canton_id FROM canton WHERE short_code = 'TI'), 'TI_TRAC'),
    ((SELECT canton_id FROM canton WHERE short_code = 'TI'), 'TI_TRAP'),
    ((SELECT canton_id FROM canton WHERE short_code = 'TI'), 'TI_TRPI'),
    ((SELECT canton_id FROM canton WHERE short_code = 'TI'), 'TI_XX'),
    ((SELECT canton_id FROM canton WHERE short_code = 'UR'), 'UR_REB'),
    ((SELECT canton_id FROM canton WHERE short_code = 'UR'), 'UR_XX'),
    ((SELECT canton_id FROM canton WHERE short_code = 'VD'), 'VD_SR'),
    ((SELECT canton_id FROM canton WHERE short_code = 'VD'), 'VD_TC'),
    ((SELECT canton_id FROM canton WHERE short_code = 'VD'), 'VD_TN'),
    ((SELECT canton_id FROM canton WHERE short_code = 'VD'), 'VD_TPHA'),
    ((SELECT canton_id FROM canton WHERE short_code = 'VD'), 'VD_XX'),
    ((SELECT canton_id FROM canton WHERE short_code = 'VS'), 'VS_AG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'VS'), 'VS_BZG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'VS'), 'VS_SRK'),
    ((SELECT canton_id FROM canton WHERE short_code = 'VS'), 'VS_TC'),
    ((SELECT canton_id FROM canton WHERE short_code = 'VS'), 'VS_XX'),
    ((SELECT canton_id FROM canton WHERE short_code = 'ZG'), 'ZG_VG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'ZG'), 'ZG_XX'),
    ((SELECT canton_id FROM canton WHERE short_code = 'ZH'), 'ZH_BK'),
    ((SELECT canton_id FROM canton WHERE short_code = 'ZH'), 'ZH_BRK'),
    ((SELECT canton_id FROM canton WHERE short_code = 'ZH'), 'ZH_HG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'ZH'), 'ZH_KSG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'ZH'), 'ZH_OG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'ZH'), 'ZH_SOBE'),
    ((SELECT canton_id FROM canton WHERE short_code = 'ZH'), 'ZH_SRK'),
    ((SELECT canton_id FROM canton WHERE short_code = 'ZH'), 'ZH_SVG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'ZH'), 'ZH_VG'),
    ((SELECT canton_id FROM canton WHERE short_code = 'ZH'), 'ZH_XX')
;

INSERT INTO court_name(court_id, "language_id", "name") VALUES 
        ((SELECT court_id FROM court WHERE court_string = 'AG_AK'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Anwaltskommission'),
        ((SELECT court_id FROM court WHERE court_string = 'AG_AK'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Anwaltskommission'),
        ((SELECT court_id FROM court WHERE court_string = 'AG_AK'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Anwaltskommission'),
        ((SELECT court_id FROM court WHERE court_string = 'AG_LWRK'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Landwirtschaftliche Rekurskommission'),
        ((SELECT court_id FROM court WHERE court_string = 'AG_LWRK'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Landwirtschaftliche Rekurskommission'),
        ((SELECT court_id FROM court WHERE court_string = 'AG_LWRK'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Landwirtschaftliche Rekurskommission'),
        ((SELECT court_id FROM court WHERE court_string = 'AG_OG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Obergericht'),
        ((SELECT court_id FROM court WHERE court_string = 'AG_OG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Obergericht'),
        ((SELECT court_id FROM court WHERE court_string = 'AG_OG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Obergericht'),
        ((SELECT court_id FROM court WHERE court_string = 'AG_OGA'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Obergericht (AGVE)'),
        ((SELECT court_id FROM court WHERE court_string = 'AG_OGA'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Obergericht (AGVE)'),
        ((SELECT court_id FROM court WHERE court_string = 'AG_OGA'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Obergericht (AGVE)'),
        ((SELECT court_id FROM court WHERE court_string = 'AG_OSB'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Oberschätzungsbehörde nach Versicherungsgesetz'),
        ((SELECT court_id FROM court WHERE court_string = 'AG_OSB'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Oberschätzungsbehörde nach Versicherungsgesetz'),
        ((SELECT court_id FROM court WHERE court_string = 'AG_OSB'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Oberschätzungsbehörde nach Versicherungsgesetz'),
        ((SELECT court_id FROM court WHERE court_string = 'AG_PRG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Personalrekursgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'AG_PRG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Personalrekursgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'AG_PRG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Personalrekursgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'AG_RGAR'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Rekursgericht im Ausländerrecht'),
        ((SELECT court_id FROM court WHERE court_string = 'AG_RGAR'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Rekursgericht im Ausländerrecht'),
        ((SELECT court_id FROM court WHERE court_string = 'AG_RGAR'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Rekursgericht im Ausländerrecht'),
        ((SELECT court_id FROM court WHERE court_string = 'AG_SKBG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Schätzungskommission nach Baugesetz'),
        ((SELECT court_id FROM court WHERE court_string = 'AG_SKBG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Schätzungskommission nach Baugesetz'),
        ((SELECT court_id FROM court WHERE court_string = 'AG_SKBG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Schätzungskommission nach Baugesetz'),
        ((SELECT court_id FROM court WHERE court_string = 'AG_SRG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Steuerrekursgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'AG_SRG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Steuerrekursgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'AG_SRG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Steuerrekursgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'AG_SVWG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Spezialverwaltungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'AG_SVWG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Spezialverwaltungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'AG_SVWG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Spezialverwaltungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'AG_VB'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Verwaltungsbehörden'),
        ((SELECT court_id FROM court WHERE court_string = 'AG_VB'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Verwaltungsbehörden'),
        ((SELECT court_id FROM court WHERE court_string = 'AG_VB'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Verwaltungsbehörden'),
        ((SELECT court_id FROM court WHERE court_string = 'AG_XX'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'unbekanntes Gericht'),
        ((SELECT court_id FROM court WHERE court_string = 'AG_XX'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'tribunal inconnu'),
        ((SELECT court_id FROM court WHERE court_string = 'AG_XX'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'corte sconosciuta'),
        ((SELECT court_id FROM court WHERE court_string = 'AI_BZG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Bezirksgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'AI_BZG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Bezirksgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'AI_BZG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Bezirksgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'AI_KG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Kantonsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'AI_KG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Kantonsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'AI_KG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Kantonsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'AI_XX'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Sammelwerk'),
        ((SELECT court_id FROM court WHERE court_string = 'AI_XX'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Sammelwerk'),
        ((SELECT court_id FROM court WHERE court_string = 'AI_XX'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Sammelwerk'),
        ((SELECT court_id FROM court WHERE court_string = 'AR_KG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Kantonsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'AR_KG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Kantonsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'AR_KG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Kantonsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'AR_OG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Obergericht'),
        ((SELECT court_id FROM court WHERE court_string = 'AR_OG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Obergericht'),
        ((SELECT court_id FROM court WHERE court_string = 'AR_OG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Obergericht'),
        ((SELECT court_id FROM court WHERE court_string = 'AR_RR'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Regierungsrat'),
        ((SELECT court_id FROM court WHERE court_string = 'AR_RR'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Regierungsrat'),
        ((SELECT court_id FROM court WHERE court_string = 'AR_RR'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Regierungsrat'),
        ((SELECT court_id FROM court WHERE court_string = 'AR_SRK'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Steuerrekurskommission'),
        ((SELECT court_id FROM court WHERE court_string = 'AR_SRK'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Steuerrekurskommission'),
        ((SELECT court_id FROM court WHERE court_string = 'AR_SRK'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Steuerrekurskommission'),
        ((SELECT court_id FROM court WHERE court_string = 'AR_VB'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Verwaltungsbehörden'),
        ((SELECT court_id FROM court WHERE court_string = 'AR_VB'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Verwaltungsbehörden'),
        ((SELECT court_id FROM court WHERE court_string = 'AR_VB'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Verwaltungsbehörden'),
        ((SELECT court_id FROM court WHERE court_string = 'AR_XX'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'unbekanntes Gericht'),
        ((SELECT court_id FROM court WHERE court_string = 'AR_XX'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'tribunal inconnu'),
        ((SELECT court_id FROM court WHERE court_string = 'AR_XX'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'corte sconosciuta'),
        ((SELECT court_id FROM court WHERE court_string = 'BE_AK'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Kantonale Anwaltsaufsichtsbehörde'),
        ((SELECT court_id FROM court WHERE court_string = 'BE_AK'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Autorité cantonale de surveillance des avocats'),
        ((SELECT court_id FROM court WHERE court_string = 'BE_AK'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Kantonale Anwaltsaufsichtsbehörde'),
        ((SELECT court_id FROM court WHERE court_string = 'BE_NAB'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Aufsichtsbehörde Notariat'),
        ((SELECT court_id FROM court WHERE court_string = 'BE_NAB'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Autorité de surveillance du notariat'),
        ((SELECT court_id FROM court WHERE court_string = 'BE_NAB'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Aufsichtsbehörde Notariat'),
        ((SELECT court_id FROM court WHERE court_string = 'BE_OG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Obergericht'),
        ((SELECT court_id FROM court WHERE court_string = 'BE_OG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Cour suprême'),
        ((SELECT court_id FROM court WHERE court_string = 'BE_OG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Obergericht'),
        ((SELECT court_id FROM court WHERE court_string = 'BE_SRK'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Steuerrekurskommission'),
        ((SELECT court_id FROM court WHERE court_string = 'BE_SRK'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Commission des recours en matière fiscale'),
        ((SELECT court_id FROM court WHERE court_string = 'BE_SRK'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Steuerrekurskommission'),
        ((SELECT court_id FROM court WHERE court_string = 'BE_VB'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Verwaltungsbehörden'),
        ((SELECT court_id FROM court WHERE court_string = 'BE_VB'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Autorités administratives'),
        ((SELECT court_id FROM court WHERE court_string = 'BE_VB'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Verwaltungsbehörden'),
        ((SELECT court_id FROM court WHERE court_string = 'BE_VG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Verwaltungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'BE_VG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Tribunal administratif'),
        ((SELECT court_id FROM court WHERE court_string = 'BE_VG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Verwaltungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'BE_XX'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'unbekanntes Gericht'),
        ((SELECT court_id FROM court WHERE court_string = 'BE_XX'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'tribunal inconnu'),
        ((SELECT court_id FROM court WHERE court_string = 'BE_XX'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'corte sconosciuta'),
        ((SELECT court_id FROM court WHERE court_string = 'BL_EG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Enteignungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'BL_EG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Enteignungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'BL_EG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Enteignungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'BL_KG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Kantonsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'BL_KG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Kantonsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'BL_KG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Kantonsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'BL_SG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Steuergericht'),
        ((SELECT court_id FROM court WHERE court_string = 'BL_SG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Steuergericht'),
        ((SELECT court_id FROM court WHERE court_string = 'BL_SG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Steuergericht'),
        ((SELECT court_id FROM court WHERE court_string = 'BL_XX'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'unbekanntes Gericht'),
        ((SELECT court_id FROM court WHERE court_string = 'BL_XX'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'tribunal inconnu'),
        ((SELECT court_id FROM court WHERE court_string = 'BL_XX'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'corte sconosciuta'),
        ((SELECT court_id FROM court WHERE court_string = 'BL_ZMG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Zwangsmassnahmengericht'),
        ((SELECT court_id FROM court WHERE court_string = 'BL_ZMG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Zwangsmassnahmengericht'),
        ((SELECT court_id FROM court WHERE court_string = 'BL_ZMG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Zwangsmassnahmengericht'),
        ((SELECT court_id FROM court WHERE court_string = 'BS_APG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Appellationsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'BS_APG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Appellationsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'BS_APG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Appellationsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'BS_SVG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Sozialversicherungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'BS_SVG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Sozialversicherungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'BS_SVG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Sozialversicherungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'BS_XX'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'unbekanntes Gericht'),
        ((SELECT court_id FROM court WHERE court_string = 'BS_XX'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'tribunal inconnu'),
        ((SELECT court_id FROM court WHERE court_string = 'BS_XX'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'corte sconosciuta'),
        ((SELECT court_id FROM court WHERE court_string = 'CH_BGE'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Bundesgericht (BGE)'),
        ((SELECT court_id FROM court WHERE court_string = 'CH_BGE'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Tribunal fédéral (ATF)'),
        ((SELECT court_id FROM court WHERE court_string = 'CH_BGE'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Tribunale federale (DTF)'),
        ((SELECT court_id FROM court WHERE court_string = 'CH_BGer'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Bundesgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'CH_BGer'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Tribunal fédéral'),
        ((SELECT court_id FROM court WHERE court_string = 'CH_BGer'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Tribunale federale'),
        ((SELECT court_id FROM court WHERE court_string = 'CH_BSTG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Bundesstrafgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'CH_BSTG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Tribunal pénal fédéral'),
        ((SELECT court_id FROM court WHERE court_string = 'CH_BSTG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Tribunale penale federale'),
        ((SELECT court_id FROM court WHERE court_string = 'CH_BVGE'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Bundesverwaltungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'CH_BVGE'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Bundesverwaltungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'CH_BVGE'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Bundesverwaltungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'CH_EDÖB'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Eidgenössischer Datenschutz- und Öffentlichkeitsbeauftragter'),
        ((SELECT court_id FROM court WHERE court_string = 'CH_EDÖB'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Eidgenössischer Datenschutz- und Öffentlichkeitsbeauftragter'),
        ((SELECT court_id FROM court WHERE court_string = 'CH_EDÖB'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Eidgenössischer Datenschutz- und Öffentlichkeitsbeauftragter'),
        ((SELECT court_id FROM court WHERE court_string = 'CH_PATG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Bundespatentgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'CH_PATG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Bundespatentgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'CH_PATG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Bundespatentgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Verwaltungspraxis der Bundesbehörden (1987-2017)'),
        ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Jurisprudence des autorités administratives de la Confédération (1987-2017) '),
        ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Giurisprudenza delle autorità amministrative della Confederazione (1987-2017)'),
        ((SELECT court_id FROM court WHERE court_string = 'CH_WBK'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Wettbewerbskommission'),
        ((SELECT court_id FROM court WHERE court_string = 'CH_WBK'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Wettbewerbskommission'),
        ((SELECT court_id FROM court WHERE court_string = 'CH_WBK'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Wettbewerbskommission'),
        ((SELECT court_id FROM court WHERE court_string = 'CH_XX'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'unbekanntes Gericht'),
        ((SELECT court_id FROM court WHERE court_string = 'CH_XX'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'tribunal inconnu'),
        ((SELECT court_id FROM court WHERE court_string = 'CH_XX'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'corte sconosciuta'),
        ((SELECT court_id FROM court WHERE court_string = 'FR_TAMA'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Schiedsgericht in Sachen Kranken- und Unfallversicherung'),
        ((SELECT court_id FROM court WHERE court_string = 'FR_TAMA'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Tribunal arbitral en matière d''assurance-maladie et accidents'),
        ((SELECT court_id FROM court WHERE court_string = 'FR_TAMA'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Schiedsgericht in Sachen Kranken- und Unfallversicherung'),
        ((SELECT court_id FROM court WHERE court_string = 'FR_TC'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Kantonsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'FR_TC'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Tribunal cantonal'),
        ((SELECT court_id FROM court WHERE court_string = 'FR_TC'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Kantonsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'FR_XX'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'unbekanntes Gericht'),
        ((SELECT court_id FROM court WHERE court_string = 'FR_XX'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'tribunal inconnu'),
        ((SELECT court_id FROM court WHERE court_string = 'FR_XX'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'corte sconosciuta'),
        ((SELECT court_id FROM court WHERE court_string = 'GE_CAPJ'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Court d''appel du pouvoir judiciaire'),
        ((SELECT court_id FROM court WHERE court_string = 'GE_CAPJ'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Court d''appel du pouvoir judiciaire'),
        ((SELECT court_id FROM court WHERE court_string = 'GE_CAPJ'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Court d''appel du pouvoir judiciaire'),
        ((SELECT court_id FROM court WHERE court_string = 'GE_CJ'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Cour de Justice (Cour civile)'),
        ((SELECT court_id FROM court WHERE court_string = 'GE_CJ'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Cour de Justice (Cour civile)'),
        ((SELECT court_id FROM court WHERE court_string = 'GE_CJ'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Cour de Justice (Cour civile)'),
        ((SELECT court_id FROM court WHERE court_string = 'GE_TAPI'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Tribunal administratif de première instance en matière fiscale'),
        ((SELECT court_id FROM court WHERE court_string = 'GE_TAPI'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Tribunal administratif de première instance en matière fiscale'),
        ((SELECT court_id FROM court WHERE court_string = 'GE_TAPI'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Tribunal administratif de première instance en matière fiscale'),
        ((SELECT court_id FROM court WHERE court_string = 'GE_TP'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Tribunal pénal'),
        ((SELECT court_id FROM court WHERE court_string = 'GE_TP'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Tribunal pénal'),
        ((SELECT court_id FROM court WHERE court_string = 'GE_TP'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Tribunal pénal'),
        ((SELECT court_id FROM court WHERE court_string = 'GE_XX'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'unbekanntes Gericht'),
        ((SELECT court_id FROM court WHERE court_string = 'GE_XX'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'tribunal inconnu'),
        ((SELECT court_id FROM court WHERE court_string = 'GE_XX'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'corte sconosciuta'),
        ((SELECT court_id FROM court WHERE court_string = 'GL_KG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Kantonsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'GL_KG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Kantonsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'GL_KG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Kantonsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'GL_OG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Obergericht'),
        ((SELECT court_id FROM court WHERE court_string = 'GL_OG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Obergericht'),
        ((SELECT court_id FROM court WHERE court_string = 'GL_OG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Obergericht'),
        ((SELECT court_id FROM court WHERE court_string = 'GL_VG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Verwaltungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'GL_VG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Verwaltungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'GL_VG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Verwaltungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'GL_XX'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'sonstige Gerichte'),
        ((SELECT court_id FROM court WHERE court_string = 'GL_XX'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'sonstige Gerichte'),
        ((SELECT court_id FROM court WHERE court_string = 'GL_XX'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'sonstige Gerichte'),
        ((SELECT court_id FROM court WHERE court_string = 'GR_KG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Kantonsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'GR_KG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Kantonsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'GR_KG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Tribunale cantonale'),
        ((SELECT court_id FROM court WHERE court_string = 'GR_VG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Verwaltungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'GR_VG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Verwaltungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'GR_VG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Tribunale amministrativo'),
        ((SELECT court_id FROM court WHERE court_string = 'GR_XX'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'unbekanntes Gericht'),
        ((SELECT court_id FROM court WHERE court_string = 'GR_XX'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'tribunal inconnu'),
        ((SELECT court_id FROM court WHERE court_string = 'GR_XX'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'corte sconosciuta'),
        ((SELECT court_id FROM court WHERE court_string = 'JU_TC'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Tribunal Cantonal'),
        ((SELECT court_id FROM court WHERE court_string = 'JU_TC'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Tribunal Cantonal'),
        ((SELECT court_id FROM court WHERE court_string = 'JU_TC'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Tribunal Cantonal'),
        ((SELECT court_id FROM court WHERE court_string = 'JU_TPI'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Tribunal de première instance'),
        ((SELECT court_id FROM court WHERE court_string = 'JU_TPI'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Tribunal de première instance'),
        ((SELECT court_id FROM court WHERE court_string = 'JU_TPI'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Tribunal de première instance'),
        ((SELECT court_id FROM court WHERE court_string = 'JU_XX'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'unbekanntes Gericht'),
        ((SELECT court_id FROM court WHERE court_string = 'JU_XX'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'tribunal inconnu'),
        ((SELECT court_id FROM court WHERE court_string = 'JU_XX'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'corte sconosciuta'),
        ((SELECT court_id FROM court WHERE court_string = 'LU_AUK'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Aufsichtsbehörden und Kommissionen'),
        ((SELECT court_id FROM court WHERE court_string = 'LU_AUK'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Aufsichtsbehörden und Kommissionen'),
        ((SELECT court_id FROM court WHERE court_string = 'LU_AUK'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Aufsichtsbehörden und Kommissionen'),
        ((SELECT court_id FROM court WHERE court_string = 'LU_BKD'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Bildungs- und Kulturdepartement'),
        ((SELECT court_id FROM court WHERE court_string = 'LU_BKD'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Bildungs- und Kulturdepartement'),
        ((SELECT court_id FROM court WHERE court_string = 'LU_BKD'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Bildungs- und Kulturdepartement'),
        ((SELECT court_id FROM court WHERE court_string = 'LU_BZG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Erstinstanzliche Gerichte'),
        ((SELECT court_id FROM court WHERE court_string = 'LU_BZG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Erstinstanzliche Gerichte'),
        ((SELECT court_id FROM court WHERE court_string = 'LU_BZG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Erstinstanzliche Gerichte'),
        ((SELECT court_id FROM court WHERE court_string = 'LU_GSD'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Gesundheits- und Sozialdepartement'),
        ((SELECT court_id FROM court WHERE court_string = 'LU_GSD'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Gesundheits- und Sozialdepartement'),
        ((SELECT court_id FROM court WHERE court_string = 'LU_GSD'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Gesundheits- und Sozialdepartement'),
        ((SELECT court_id FROM court WHERE court_string = 'LU_JSD'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Justiz- und Sicherheitsdepartement'),
        ((SELECT court_id FROM court WHERE court_string = 'LU_JSD'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Justiz- und Sicherheitsdepartement'),
        ((SELECT court_id FROM court WHERE court_string = 'LU_JSD'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Justiz- und Sicherheitsdepartement'),
        ((SELECT court_id FROM court WHERE court_string = 'LU_KG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Kantonsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'LU_KG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Kantonsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'LU_KG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Kantonsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'LU_RR'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Regierungsrat'),
        ((SELECT court_id FROM court WHERE court_string = 'LU_RR'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Regierungsrat'),
        ((SELECT court_id FROM court WHERE court_string = 'LU_RR'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Regierungsrat'),
        ((SELECT court_id FROM court WHERE court_string = 'LU_RSH'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Regierungsstatthalter'),
        ((SELECT court_id FROM court WHERE court_string = 'LU_RSH'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Regierungsstatthalter'),
        ((SELECT court_id FROM court WHERE court_string = 'LU_RSH'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Regierungsstatthalter'),
        ((SELECT court_id FROM court WHERE court_string = 'LU_XX'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'unbekanntes Gericht'),
        ((SELECT court_id FROM court WHERE court_string = 'LU_XX'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'tribunal inconnu'),
        ((SELECT court_id FROM court WHERE court_string = 'LU_XX'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'corte sconosciuta'),
        ((SELECT court_id FROM court WHERE court_string = 'NE_ARA'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Autorité de recours des avocates, des avocats et du notariat'),
        ((SELECT court_id FROM court WHERE court_string = 'NE_ARA'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Autorité de recours des avocates, des avocats et du notariat'),
        ((SELECT court_id FROM court WHERE court_string = 'NE_ARA'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Autorité de recours des avocates, des avocats et du notariat'),
        ((SELECT court_id FROM court WHERE court_string = 'NE_ASL'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Autorité de surveillance LP'),
        ((SELECT court_id FROM court WHERE court_string = 'NE_ASL'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Autorité de surveillance LP'),
        ((SELECT court_id FROM court WHERE court_string = 'NE_ASL'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Autorité de surveillance LP'),
        ((SELECT court_id FROM court WHERE court_string = 'NE_ASS'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Autorité supérieure de surveillance LP'),
        ((SELECT court_id FROM court WHERE court_string = 'NE_ASS'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Autorité supérieure de surveillance LP'),
        ((SELECT court_id FROM court WHERE court_string = 'NE_ASS'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Autorité supérieure de surveillance LP'),
        ((SELECT court_id FROM court WHERE court_string = 'NE_ATS'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Autorité tutélaire de surveillance'),
        ((SELECT court_id FROM court WHERE court_string = 'NE_ATS'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Autorité tutélaire de surveillance'),
        ((SELECT court_id FROM court WHERE court_string = 'NE_ATS'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Autorité tutélaire de surveillance'),
        ((SELECT court_id FROM court WHERE court_string = 'NE_CA'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Autorité de surveillance des avocats'),
        ((SELECT court_id FROM court WHERE court_string = 'NE_CA'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Autorité de surveillance des avocats'),
        ((SELECT court_id FROM court WHERE court_string = 'NE_CA'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Autorité de surveillance des avocats'),
        ((SELECT court_id FROM court WHERE court_string = 'NE_CN'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Autorité de surveillance du notariat'),
        ((SELECT court_id FROM court WHERE court_string = 'NE_CN'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Autorité de surveillance du notariat'),
        ((SELECT court_id FROM court WHERE court_string = 'NE_CN'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Autorité de surveillance du notariat'),
        ((SELECT court_id FROM court WHERE court_string = 'NE_TC'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Tribunal Cantonal'),
        ((SELECT court_id FROM court WHERE court_string = 'NE_TC'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Tribunal Cantonal'),
        ((SELECT court_id FROM court WHERE court_string = 'NE_TC'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Tribunal Cantonal'),
        ((SELECT court_id FROM court WHERE court_string = 'NE_TR'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Tribunaux régional - Civil'),
        ((SELECT court_id FROM court WHERE court_string = 'NE_TR'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Tribunaux régional - Civil'),
        ((SELECT court_id FROM court WHERE court_string = 'NE_TR'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Tribunaux régional - Civil'),
        ((SELECT court_id FROM court WHERE court_string = 'NE_XX'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'unbekanntes Gericht'),
        ((SELECT court_id FROM court WHERE court_string = 'NE_XX'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'tribunal inconnu'),
        ((SELECT court_id FROM court WHERE court_string = 'NE_XX'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'corte sconosciuta'),
        ((SELECT court_id FROM court WHERE court_string = 'NW_OG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Gerichte'),
        ((SELECT court_id FROM court WHERE court_string = 'NW_OG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Gerichte'),
        ((SELECT court_id FROM court WHERE court_string = 'NW_OG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Gerichte'),
        ((SELECT court_id FROM court WHERE court_string = 'NW_XX'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'unbekanntes Gericht'),
        ((SELECT court_id FROM court WHERE court_string = 'NW_XX'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'tribunal inconnu'),
        ((SELECT court_id FROM court WHERE court_string = 'NW_XX'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'corte sconosciuta'),
        ((SELECT court_id FROM court WHERE court_string = 'OW_OG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Amtsbericht über die Rechtspflege (AbR)'),
        ((SELECT court_id FROM court WHERE court_string = 'OW_OG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Amtsbericht über die Rechtspflege (AbR)'),
        ((SELECT court_id FROM court WHERE court_string = 'OW_OG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Amtsbericht über die Rechtspflege (AbR)'),
        ((SELECT court_id FROM court WHERE court_string = 'OW_VB'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Gerichts- und Verwaltungsentscheide (OGVE)'),
        ((SELECT court_id FROM court WHERE court_string = 'OW_VB'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Gerichts- und Verwaltungsentscheide (OGVE)'),
        ((SELECT court_id FROM court WHERE court_string = 'OW_VB'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Gerichts- und Verwaltungsentscheide (OGVE)'),
        ((SELECT court_id FROM court WHERE court_string = 'OW_VG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Verwaltungs- und Verwaltungsgerichtsentscheide (VVGE)'),
        ((SELECT court_id FROM court WHERE court_string = 'OW_VG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Verwaltungs- und Verwaltungsgerichtsentscheide (VVGE)'),
        ((SELECT court_id FROM court WHERE court_string = 'OW_VG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Verwaltungs- und Verwaltungsgerichtsentscheide (VVGE)'),
        ((SELECT court_id FROM court WHERE court_string = 'OW_XX'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Sonstiges'),
        ((SELECT court_id FROM court WHERE court_string = 'OW_XX'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Sonstiges'),
        ((SELECT court_id FROM court WHERE court_string = 'OW_XX'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Sonstiges'),
        ((SELECT court_id FROM court WHERE court_string = 'SG_ABSK'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Kantonale Aufsichtsbehörde für Schuldbetreibung und Konkurs'),
        ((SELECT court_id FROM court WHERE court_string = 'SG_ABSK'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Kantonale Aufsichtsbehörde für Schuldbetreibung und Konkurs'),
        ((SELECT court_id FROM court WHERE court_string = 'SG_ABSK'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Kantonale Aufsichtsbehörde für Schuldbetreibung und Konkurs'),
        ((SELECT court_id FROM court WHERE court_string = 'SG_HG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Handelsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SG_HG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Handelsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SG_HG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Handelsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SG_KG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Kantonsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SG_KG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Kantonsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SG_KG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Kantonsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SG_KGN'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Kantonsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SG_KGN'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Kantonsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SG_KGN'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Kantonsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SG_VB'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Verwaltungsbehörden'),
        ((SELECT court_id FROM court WHERE court_string = 'SG_VB'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Verwaltungsbehörden'),
        ((SELECT court_id FROM court WHERE court_string = 'SG_VB'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Verwaltungsbehörden'),
        ((SELECT court_id FROM court WHERE court_string = 'SG_VG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Verwaltungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SG_VG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Verwaltungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SG_VG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Verwaltungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SG_VGN'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Verwaltungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SG_VGN'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Verwaltungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SG_VGN'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Verwaltungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SG_VSG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Versicherungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SG_VSG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Versicherungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SG_VSG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Versicherungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SG_VWEK'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Verwaltungsrekurskommission'),
        ((SELECT court_id FROM court WHERE court_string = 'SG_VWEK'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Verwaltungsrekurskommission'),
        ((SELECT court_id FROM court WHERE court_string = 'SG_VWEK'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Verwaltungsrekurskommission'),
        ((SELECT court_id FROM court WHERE court_string = 'SG_XX'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'unbekanntes Gericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SG_XX'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'tribunal inconnu'),
        ((SELECT court_id FROM court WHERE court_string = 'SG_XX'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'corte sconosciuta'),
        ((SELECT court_id FROM court WHERE court_string = 'SH_OG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Obergericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SH_OG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Obergericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SH_OG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Obergericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SH_XX'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'unbekanntes Gericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SH_XX'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'tribunal inconnu'),
        ((SELECT court_id FROM court WHERE court_string = 'SH_XX'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'corte sconosciuta'),
        ((SELECT court_id FROM court WHERE court_string = 'SO_OG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Obergericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SO_OG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Obergericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SO_OG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Obergericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SO_SK'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Schätzungskommission'),
        ((SELECT court_id FROM court WHERE court_string = 'SO_SK'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Schätzungskommission'),
        ((SELECT court_id FROM court WHERE court_string = 'SO_SK'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Schätzungskommission'),
        ((SELECT court_id FROM court WHERE court_string = 'SO_STG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Steuergericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SO_STG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Steuergericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SO_STG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Steuergericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SO_VG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Verwaltungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SO_VG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Verwaltungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SO_VG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Verwaltungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SO_VSG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Versicherungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SO_VSG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Versicherungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SO_VSG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Versicherungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SO_XX'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'unbekanntes Gericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SO_XX'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'tribunal inconnu'),
        ((SELECT court_id FROM court WHERE court_string = 'SO_XX'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'corte sconosciuta'),
        ((SELECT court_id FROM court WHERE court_string = 'SZ_KG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Kantonsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SZ_KG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Kantonsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SZ_KG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Kantonsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SZ_XX'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'unbekanntes Gericht'),
        ((SELECT court_id FROM court WHERE court_string = 'SZ_XX'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'tribunal inconnu'),
        ((SELECT court_id FROM court WHERE court_string = 'SZ_XX'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'corte sconosciuta'),
        ((SELECT court_id FROM court WHERE court_string = 'TG_OG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Obergericht'),
        ((SELECT court_id FROM court WHERE court_string = 'TG_OG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Obergericht'),
        ((SELECT court_id FROM court WHERE court_string = 'TG_OG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Obergericht'),
        ((SELECT court_id FROM court WHERE court_string = 'TG_XX'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'unbekanntes Gericht'),
        ((SELECT court_id FROM court WHERE court_string = 'TG_XX'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'tribunal inconnu'),
        ((SELECT court_id FROM court WHERE court_string = 'TG_XX'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'corte sconosciuta'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_CARP'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Corte di appello e di revisione penale'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_CARP'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Corte di appello e di revisione penale'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_CARP'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Corte di appello e di revisione penale'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_CATI'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Camera di diritto tributario'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_CATI'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Camera di diritto tributario'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_CATI'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Camera di diritto tributario'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_CRP'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Camera dei ricorsi penali'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_CRP'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Camera dei ricorsi penali'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_CRP'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Camera dei ricorsi penali'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_GIAR'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Il Giudice dell''istruzione e dell''arresto'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_GIAR'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Il Giudice dell''istruzione e dell''arresto'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_GIAR'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Il Giudice dell''istruzione e dell''arresto'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_GPC'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Ufficio del giudice dei provvedimenti coercitivi'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_GPC'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Ufficio del giudice dei provvedimenti coercitivi'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_GPC'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Ufficio del giudice dei provvedimenti coercitivi'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_PP'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Il Presidente della Pretura Penale'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_PP'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Il Presidente della Pretura Penale'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_PP'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Il Presidente della Pretura Penale'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_TCA'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Tribunale cantonale amministrativo'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_TCA'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Tribunale cantonale amministrativo'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_TCA'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Tribunale cantonale amministrativo'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_TCAS'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Tribunale cantonale delle assicurazioni'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_TCAS'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Tribunale cantonale delle assicurazioni'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_TCAS'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Tribunale cantonale delle assicurazioni'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_TE'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Tribunale di espropriazione'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_TE'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Tribunale di espropriazione'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_TE'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Tribunale di espropriazione'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_TPC'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Tribunale penale cantonale'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_TPC'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Tribunale penale cantonale'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_TPC'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Tribunale penale cantonale'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_TRAC'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Tribunale di appello diritto civile'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_TRAC'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Tribunale di appello diritto civile'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_TRAC'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Tribunale di appello diritto civile'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_TRAP'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Tribunale di appello diritto penale'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_TRAP'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Tribunale di appello diritto penale'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_TRAP'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Tribunale di appello diritto penale'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_TRPI'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Tribunale della pianificazione'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_TRPI'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Tribunale della pianificazione'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_TRPI'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Tribunale della pianificazione'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_XX'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Diversi'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_XX'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Diversi'),
        ((SELECT court_id FROM court WHERE court_string = 'TI_XX'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Diversi'),
        ((SELECT court_id FROM court WHERE court_string = 'UR_REB'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Rechenschaftsbericht über die Rechtspflege'),
        ((SELECT court_id FROM court WHERE court_string = 'UR_REB'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Rechenschaftsbericht über die Rechtspflege'),
        ((SELECT court_id FROM court WHERE court_string = 'UR_REB'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Rechenschaftsbericht über die Rechtspflege'),
        ((SELECT court_id FROM court WHERE court_string = 'UR_XX'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'unbekanntes Gericht'),
        ((SELECT court_id FROM court WHERE court_string = 'UR_XX'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'tribunal inconnu'),
        ((SELECT court_id FROM court WHERE court_string = 'UR_XX'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'corte sconosciuta'),
        ((SELECT court_id FROM court WHERE court_string = 'VD_SR'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Conseil d''État'),
        ((SELECT court_id FROM court WHERE court_string = 'VD_SR'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Conseil d''État'),
        ((SELECT court_id FROM court WHERE court_string = 'VD_SR'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Conseil d''État'),
        ((SELECT court_id FROM court WHERE court_string = 'VD_TC'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Tribunal cantonal'),
        ((SELECT court_id FROM court WHERE court_string = 'VD_TC'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Tribunal cantonal'),
        ((SELECT court_id FROM court WHERE court_string = 'VD_TC'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Tribunal cantonal'),
        ((SELECT court_id FROM court WHERE court_string = 'VD_TN'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Tribunal neutre'),
        ((SELECT court_id FROM court WHERE court_string = 'VD_TN'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Tribunal neutre'),
        ((SELECT court_id FROM court WHERE court_string = 'VD_TN'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Tribunal neutre'),
        ((SELECT court_id FROM court WHERE court_string = 'VD_TPHA'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Tribunal de Prud''hommes de l''Administration cantonale'),
        ((SELECT court_id FROM court WHERE court_string = 'VD_TPHA'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Tribunal de Prud''hommes de l''Administration cantonale'),
        ((SELECT court_id FROM court WHERE court_string = 'VD_TPHA'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Tribunal de Prud''hommes de l''Administration cantonale'),
        ((SELECT court_id FROM court WHERE court_string = 'VD_XX'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'unbekanntes Gericht'),
        ((SELECT court_id FROM court WHERE court_string = 'VD_XX'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'tribunal inconnu'),
        ((SELECT court_id FROM court WHERE court_string = 'VD_XX'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'corte sconosciuta'),
        ((SELECT court_id FROM court WHERE court_string = 'VS_AG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Arbeitsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'VS_AG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Tribunal du travail'),
        ((SELECT court_id FROM court WHERE court_string = 'VS_AG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Arbeitsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'VS_BZG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Bezirksgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'VS_BZG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Tribunal du district'),
        ((SELECT court_id FROM court WHERE court_string = 'VS_BZG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Bezirksgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'VS_SRK'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Kantonale Steuerrekurskommission'),
        ((SELECT court_id FROM court WHERE court_string = 'VS_SRK'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Commission cantonale de recours en matière fiscale'),
        ((SELECT court_id FROM court WHERE court_string = 'VS_SRK'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Kantonale Steuerrekurskommission'),
        ((SELECT court_id FROM court WHERE court_string = 'VS_TC'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Kantonsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'VS_TC'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Tribunal cantonal'),
        ((SELECT court_id FROM court WHERE court_string = 'VS_TC'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Kantonsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'VS_XX'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Sonstiges'),
        ((SELECT court_id FROM court WHERE court_string = 'VS_XX'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Autres'),
        ((SELECT court_id FROM court WHERE court_string = 'VS_XX'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Sonstiges'),
        ((SELECT court_id FROM court WHERE court_string = 'ZG_VG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Verwaltungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'ZG_VG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Verwaltungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'ZG_VG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Verwaltungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'ZG_XX'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'unbekanntes Gericht'),
        ((SELECT court_id FROM court WHERE court_string = 'ZG_XX'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'tribunal inconnu'),
        ((SELECT court_id FROM court WHERE court_string = 'ZG_XX'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'corte sconosciuta'),
        ((SELECT court_id FROM court WHERE court_string = 'ZH_BK'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Bezirksgerichte'),
        ((SELECT court_id FROM court WHERE court_string = 'ZH_BK'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Bezirksgerichte'),
        ((SELECT court_id FROM court WHERE court_string = 'ZH_BK'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Bezirksgerichte'),
        ((SELECT court_id FROM court WHERE court_string = 'ZH_BRK'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Baurekursgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'ZH_BRK'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Baurekursgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'ZH_BRK'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Baurekursgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'ZH_HG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Handelsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'ZH_HG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Handelsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'ZH_HG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Handelsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'ZH_KSG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Kassationsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'ZH_KSG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Kassationsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'ZH_KSG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Kassationsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'ZH_OG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Obergericht'),
        ((SELECT court_id FROM court WHERE court_string = 'ZH_OG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Obergericht'),
        ((SELECT court_id FROM court WHERE court_string = 'ZH_OG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Obergericht'),
        ((SELECT court_id FROM court WHERE court_string = 'ZH_SOBE'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Andere Behörden und Gerichte'),
        ((SELECT court_id FROM court WHERE court_string = 'ZH_SOBE'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Andere Behörden und Gerichte'),
        ((SELECT court_id FROM court WHERE court_string = 'ZH_SOBE'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Andere Behörden und Gerichte'),
        ((SELECT court_id FROM court WHERE court_string = 'ZH_SRK'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Steuerrekursgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'ZH_SRK'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Steuerrekursgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'ZH_SRK'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Steuerrekursgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'ZH_SVG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Sozialverischerungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'ZH_SVG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Sozialverischerungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'ZH_SVG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Sozialverischerungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'ZH_VG'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'Verwaltungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'ZH_VG'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'Verwaltungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'ZH_VG'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'Verwaltungsgericht'),
        ((SELECT court_id FROM court WHERE court_string = 'ZH_XX'), (SELECT language_id FROM language WHERE iso_code = 'de'), 'unbekanntes Gericht'),
        ((SELECT court_id FROM court WHERE court_string = 'ZH_XX'), (SELECT language_id FROM language WHERE iso_code = 'fr'), 'tribunal inconnu'),
        ((SELECT court_id FROM court WHERE court_string = 'ZH_XX'), (SELECT language_id FROM language WHERE iso_code = 'it'), 'corte sconosciuta')
;

INSERT INTO chamber(court_id, spider_id, chamber_string) VALUES 
    ((SELECT court_id FROM court WHERE court_string = 'AG_AK'), (SELECT spider_id FROM spider WHERE name = 'AG_Gerichte'), 'AG_AK_001'),
    ((SELECT court_id FROM court WHERE court_string = 'AG_LWRK'), (SELECT spider_id FROM spider WHERE name = 'AG_Gerichte'), 'AG_LWRK_001'),
    ((SELECT court_id FROM court WHERE court_string = 'AG_OG'), (SELECT spider_id FROM spider WHERE name = 'AG_Gerichte'), 'AG_OG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'AG_OG'), (SELECT spider_id FROM spider WHERE name = 'AG_Gerichte'), 'AG_OG_002'),
    ((SELECT court_id FROM court WHERE court_string = 'AG_OG'), (SELECT spider_id FROM spider WHERE name = 'AG_Gerichte'), 'AG_OG_009'),
    ((SELECT court_id FROM court WHERE court_string = 'AG_OG'), (SELECT spider_id FROM spider WHERE name = 'AG_Gerichte'), 'AG_OG_010'),
    ((SELECT court_id FROM court WHERE court_string = 'AG_OG'), (SELECT spider_id FROM spider WHERE name = 'AG_Gerichte'), 'AG_OG_011'),
    ((SELECT court_id FROM court WHERE court_string = 'AG_OG'), (SELECT spider_id FROM spider WHERE name = 'AG_Gerichte'), 'AG_OG_999'),
    ((SELECT court_id FROM court WHERE court_string = 'AG_OGA'), (SELECT spider_id FROM spider WHERE name = 'AG_Weitere'), 'AG_OGA_001'),
    ((SELECT court_id FROM court WHERE court_string = 'AG_OGA'), (SELECT spider_id FROM spider WHERE name = 'AG_Weitere'), 'AG_OGA_002'),
    ((SELECT court_id FROM court WHERE court_string = 'AG_OGA'), (SELECT spider_id FROM spider WHERE name = 'AG_Weitere'), 'AG_OGA_003'),
    ((SELECT court_id FROM court WHERE court_string = 'AG_OGA'), (SELECT spider_id FROM spider WHERE name = 'AG_Weitere'), 'AG_OGA_004'),
    ((SELECT court_id FROM court WHERE court_string = 'AG_OGA'), (SELECT spider_id FROM spider WHERE name = 'AG_Weitere'), 'AG_OGA_005'),
    ((SELECT court_id FROM court WHERE court_string = 'AG_OGA'), (SELECT spider_id FROM spider WHERE name = 'AG_Weitere'), 'AG_OGA_006'),
    ((SELECT court_id FROM court WHERE court_string = 'AG_OGA'), (SELECT spider_id FROM spider WHERE name = 'AG_Weitere'), 'AG_OGA_999'),
    ((SELECT court_id FROM court WHERE court_string = 'AG_OSB'), (SELECT spider_id FROM spider WHERE name = 'AG_Gerichte'), 'AG_OSB_001'),
    ((SELECT court_id FROM court WHERE court_string = 'AG_PRG'), (SELECT spider_id FROM spider WHERE name = 'AG_Gerichte'), 'AG_PRG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'AG_RGAR'), (SELECT spider_id FROM spider WHERE name = 'AG_Gerichte'), 'AG_RGAR_001'),
    ((SELECT court_id FROM court WHERE court_string = 'AG_SKBG'), (SELECT spider_id FROM spider WHERE name = 'AG_Gerichte'), 'AG_SKBG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'AG_SRG'), (SELECT spider_id FROM spider WHERE name = 'AG_Gerichte'), 'AG_SRG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'AG_SVWG'), (SELECT spider_id FROM spider WHERE name = 'AG_Gerichte'), 'AG_SVWG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'AG_VB'), (SELECT spider_id FROM spider WHERE name = 'AG_Gerichte'), 'AG_VB_001'),
    ((SELECT court_id FROM court WHERE court_string = 'AG_VB'), (SELECT spider_id FROM spider WHERE name = 'AG_Gerichte'), 'AG_VB_002'),
    ((SELECT court_id FROM court WHERE court_string = 'AG_VB'), (SELECT spider_id FROM spider WHERE name = 'AG_Gerichte'), 'AG_VB_999'),
    ((SELECT court_id FROM court WHERE court_string = 'AG_XX'), (SELECT spider_id FROM spider WHERE name = 'AG_Gerichte'), 'AG_XX_001'),
    ((SELECT court_id FROM court WHERE court_string = 'AI_BZG'), (SELECT spider_id FROM spider WHERE name = 'AI_Aktuell'), 'AI_BZG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'AI_KG'), (SELECT spider_id FROM spider WHERE name = 'AI_Aktuell'), 'AI_KG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'AI_XX'), (SELECT spider_id FROM spider WHERE name = 'AI_Bericht'), 'AI_XX_001'),
    ((SELECT court_id FROM court WHERE court_string = 'AR_KG'), (SELECT spider_id FROM spider WHERE name = 'AR_Gerichte'), 'AR_KG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'AR_KG'), (SELECT spider_id FROM spider WHERE name = 'AR_Gerichte'), 'AR_KG_002'),
    ((SELECT court_id FROM court WHERE court_string = 'AR_KG'), (SELECT spider_id FROM spider WHERE name = 'AR_Gerichte'), 'AR_KG_003'),
    ((SELECT court_id FROM court WHERE court_string = 'AR_KG'), (SELECT spider_id FROM spider WHERE name = 'AR_Gerichte'), 'AR_KG_004'),
    ((SELECT court_id FROM court WHERE court_string = 'AR_KG'), (SELECT spider_id FROM spider WHERE name = 'AR_Gerichte'), 'AR_KG_005'),
    ((SELECT court_id FROM court WHERE court_string = 'AR_KG'), (SELECT spider_id FROM spider WHERE name = 'AR_Gerichte'), 'AR_KG_999'),
    ((SELECT court_id FROM court WHERE court_string = 'AR_OG'), (SELECT spider_id FROM spider WHERE name = 'AR_Gerichte'), 'AR_OG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'AR_OG'), (SELECT spider_id FROM spider WHERE name = 'AR_Gerichte'), 'AR_OG_002'),
    ((SELECT court_id FROM court WHERE court_string = 'AR_OG'), (SELECT spider_id FROM spider WHERE name = 'AR_Gerichte'), 'AR_OG_003'),
    ((SELECT court_id FROM court WHERE court_string = 'AR_OG'), (SELECT spider_id FROM spider WHERE name = 'AR_Gerichte'), 'AR_OG_004'),
    ((SELECT court_id FROM court WHERE court_string = 'AR_OG'), (SELECT spider_id FROM spider WHERE name = 'AR_Gerichte'), 'AR_OG_005'),
    ((SELECT court_id FROM court WHERE court_string = 'AR_OG'), (SELECT spider_id FROM spider WHERE name = 'AR_Gerichte'), 'AR_OG_006'),
    ((SELECT court_id FROM court WHERE court_string = 'AR_OG'), (SELECT spider_id FROM spider WHERE name = 'AR_Gerichte'), 'AR_OG_007'),
    ((SELECT court_id FROM court WHERE court_string = 'AR_OG'), (SELECT spider_id FROM spider WHERE name = 'AR_Gerichte'), 'AR_OG_008'),
    ((SELECT court_id FROM court WHERE court_string = 'AR_OG'), (SELECT spider_id FROM spider WHERE name = 'AR_Gerichte'), 'AR_OG_999'),
    ((SELECT court_id FROM court WHERE court_string = 'AR_RR'), (SELECT spider_id FROM spider WHERE name = 'AR_Gerichte'), 'AR_RR_001'),
    ((SELECT court_id FROM court WHERE court_string = 'AR_SRK'), (SELECT spider_id FROM spider WHERE name = 'AR_Gerichte'), 'AR_SRK_001'),
    ((SELECT court_id FROM court WHERE court_string = 'AR_VB'), (SELECT spider_id FROM spider WHERE name = 'AR_Gerichte'), 'AR_VB_001'),
    ((SELECT court_id FROM court WHERE court_string = 'AR_XX'), (SELECT spider_id FROM spider WHERE name = 'AR_Gerichte'), 'AR_XX_001'),
    ((SELECT court_id FROM court WHERE court_string = 'BE_AK'), (SELECT spider_id FROM spider WHERE name = 'BE_Anwaltsaufsicht'), 'BE_AK_001'),
    ((SELECT court_id FROM court WHERE court_string = 'BE_NAB'), (SELECT spider_id FROM spider WHERE name = 'BE_Weitere'), 'BE_NAB_001'),
    ((SELECT court_id FROM court WHERE court_string = 'BE_NAB'), (SELECT spider_id FROM spider WHERE name = 'BE_Weitere'), 'BE_NAB_002'),
    ((SELECT court_id FROM court WHERE court_string = 'BE_NAB'), (SELECT spider_id FROM spider WHERE name = 'BE_Weitere'), 'BE_NAB_003'),
    ((SELECT court_id FROM court WHERE court_string = 'BE_NAB'), (SELECT spider_id FROM spider WHERE name = 'BE_Weitere'), 'BE_NAB_999'),
    ((SELECT court_id FROM court WHERE court_string = 'BE_OG'), (SELECT spider_id FROM spider WHERE name = 'BE_ZivilStraf'), 'BE_OG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'BE_OG'), (SELECT spider_id FROM spider WHERE name = 'BE_ZivilStraf'), 'BE_OG_002'),
    ((SELECT court_id FROM court WHERE court_string = 'BE_OG'), (SELECT spider_id FROM spider WHERE name = 'BE_ZivilStraf'), 'BE_OG_003'),
    ((SELECT court_id FROM court WHERE court_string = 'BE_OG'), (SELECT spider_id FROM spider WHERE name = 'BE_ZivilStraf'), 'BE_OG_005'),
    ((SELECT court_id FROM court WHERE court_string = 'BE_OG'), (SELECT spider_id FROM spider WHERE name = 'BE_ZivilStraf'), 'BE_OG_007'),
    ((SELECT court_id FROM court WHERE court_string = 'BE_OG'), (SELECT spider_id FROM spider WHERE name = 'BE_ZivilStraf'), 'BE_OG_008'),
    ((SELECT court_id FROM court WHERE court_string = 'BE_OG'), (SELECT spider_id FROM spider WHERE name = 'BE_ZivilStraf'), 'BE_OG_999'),
    ((SELECT court_id FROM court WHERE court_string = 'BE_SRK'), (SELECT spider_id FROM spider WHERE name = 'BE_Steuerrekurs'), 'BE_SRK_001'),
    ((SELECT court_id FROM court WHERE court_string = 'BE_VB'), (SELECT spider_id FROM spider WHERE name = 'BE_BVD'), 'BE_VB_001'),
    ((SELECT court_id FROM court WHERE court_string = 'BE_VB'), (SELECT spider_id FROM spider WHERE name = 'BE_BVD'), 'BE_VB_999'),
    ((SELECT court_id FROM court WHERE court_string = 'BE_VB'), (SELECT spider_id FROM spider WHERE name = 'BE_Weitere'), 'BE_VB_002'),
    ((SELECT court_id FROM court WHERE court_string = 'BE_VB'), (SELECT spider_id FROM spider WHERE name = 'BE_Weitere'), 'BE_VB_003'),
    ((SELECT court_id FROM court WHERE court_string = 'BE_VB'), (SELECT spider_id FROM spider WHERE name = 'BE_Weitere'), 'BE_VB_004'),
    ((SELECT court_id FROM court WHERE court_string = 'BE_VB'), (SELECT spider_id FROM spider WHERE name = 'BE_Weitere'), 'BE_VB_005'),
    ((SELECT court_id FROM court WHERE court_string = 'BE_VB'), (SELECT spider_id FROM spider WHERE name = 'BE_Weitere'), 'BE_VB_006'),
    ((SELECT court_id FROM court WHERE court_string = 'BE_VG'), (SELECT spider_id FROM spider WHERE name = 'BE_Verwaltungsgericht'), 'BE_VG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'BE_XX'), (SELECT spider_id FROM spider WHERE name = 'BE_ZivilStraf'), 'BE_XX_001'),
    ((SELECT court_id FROM court WHERE court_string = 'BL_EG'), (SELECT spider_id FROM spider WHERE name = 'BL_Gerichte'), 'BL_EG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'BL_KG'), (SELECT spider_id FROM spider WHERE name = 'BL_Gerichte'), 'BL_KG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'BL_SG'), (SELECT spider_id FROM spider WHERE name = 'BL_Gerichte'), 'BL_SG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'BL_XX'), (SELECT spider_id FROM spider WHERE name = 'BL_Gerichte'), 'BL_XX_001'),
    ((SELECT court_id FROM court WHERE court_string = 'BL_ZMG'), (SELECT spider_id FROM spider WHERE name = 'BL_Gerichte'), 'BL_ZMG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'BS_APG'), (SELECT spider_id FROM spider WHERE name = 'BS_Omni'), 'BS_APG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'BS_SVG'), (SELECT spider_id FROM spider WHERE name = 'BS_Omni'), 'BS_SVG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'BS_XX'), (SELECT spider_id FROM spider WHERE name = 'BS_Omni'), 'BS_XX_001'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_BGE'), (SELECT spider_id FROM spider WHERE name = 'CH_BGE'), 'CH_BGE_001'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_BGE'), (SELECT spider_id FROM spider WHERE name = 'CH_BGE'), 'CH_BGE_002'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_BGE'), (SELECT spider_id FROM spider WHERE name = 'CH_BGE'), 'CH_BGE_003'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_BGE'), (SELECT spider_id FROM spider WHERE name = 'CH_BGE'), 'CH_BGE_004'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_BGE'), (SELECT spider_id FROM spider WHERE name = 'CH_BGE'), 'CH_BGE_005'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_BGE'), (SELECT spider_id FROM spider WHERE name = 'CH_BGE'), 'CH_BGE_006'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_BGE'), (SELECT spider_id FROM spider WHERE name = 'CH_BGE'), 'CH_BGE_007'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_BGE'), (SELECT spider_id FROM spider WHERE name = 'CH_BGE'), 'CH_BGE_008'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_BGE'), (SELECT spider_id FROM spider WHERE name = 'CH_BGE'), 'CH_BGE_009'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_BGE'), (SELECT spider_id FROM spider WHERE name = 'CH_BGE'), 'CH_BGE_010'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_BGE'), (SELECT spider_id FROM spider WHERE name = 'CH_BGE'), 'CH_BGE_011'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_BGE'), (SELECT spider_id FROM spider WHERE name = 'CH_BGE'), 'CH_BGE_999'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_BGer'), (SELECT spider_id FROM spider WHERE name = 'CH_BGer'), 'CH_BGer_001'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_BGer'), (SELECT spider_id FROM spider WHERE name = 'CH_BGer'), 'CH_BGer_002'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_BGer'), (SELECT spider_id FROM spider WHERE name = 'CH_BGer'), 'CH_BGer_004'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_BGer'), (SELECT spider_id FROM spider WHERE name = 'CH_BGer'), 'CH_BGer_005'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_BGer'), (SELECT spider_id FROM spider WHERE name = 'CH_BGer'), 'CH_BGer_006'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_BGer'), (SELECT spider_id FROM spider WHERE name = 'CH_BGer'), 'CH_BGer_008'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_BGer'), (SELECT spider_id FROM spider WHERE name = 'CH_BGer'), 'CH_BGer_009'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_BGer'), (SELECT spider_id FROM spider WHERE name = 'CH_BGer'), 'CH_BGer_010'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_BGer'), (SELECT spider_id FROM spider WHERE name = 'CH_BGer'), 'CH_BGer_012'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_BGer'), (SELECT spider_id FROM spider WHERE name = 'CH_BGer'), 'CH_BGer_013'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_BGer'), (SELECT spider_id FROM spider WHERE name = 'CH_BGer'), 'CH_BGer_014'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_BGer'), (SELECT spider_id FROM spider WHERE name = 'CH_BGer'), 'CH_BGer_015'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_BGer'), (SELECT spider_id FROM spider WHERE name = 'CH_BGer'), 'CH_BGer_016'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_BGer'), (SELECT spider_id FROM spider WHERE name = 'CH_BGer'), 'CH_BGer_999'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_BSTG'), (SELECT spider_id FROM spider WHERE name = 'CH_BSTG'), 'CH_BSTG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_BVGE'), (SELECT spider_id FROM spider WHERE name = 'CH_BVGer'), 'CH_BVGE_001'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_EDÖB'), (SELECT spider_id FROM spider WHERE name = 'CH_EDOEB'), 'CH_EDÖB_001'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_PATG'), (SELECT spider_id FROM spider WHERE name = 'CH_BPatG'), 'CH_PATG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT spider_id FROM spider WHERE name = 'CH_VB'), 'CH_VB_001'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT spider_id FROM spider WHERE name = 'CH_VB'), 'CH_VB_002'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT spider_id FROM spider WHERE name = 'CH_VB'), 'CH_VB_003'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT spider_id FROM spider WHERE name = 'CH_VB'), 'CH_VB_004'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT spider_id FROM spider WHERE name = 'CH_VB'), 'CH_VB_005'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT spider_id FROM spider WHERE name = 'CH_VB'), 'CH_VB_006'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT spider_id FROM spider WHERE name = 'CH_VB'), 'CH_VB_007'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT spider_id FROM spider WHERE name = 'CH_VB'), 'CH_VB_008'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT spider_id FROM spider WHERE name = 'CH_VB'), 'CH_VB_009'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT spider_id FROM spider WHERE name = 'CH_VB'), 'CH_VB_010'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT spider_id FROM spider WHERE name = 'CH_VB'), 'CH_VB_011'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT spider_id FROM spider WHERE name = 'CH_VB'), 'CH_VB_012'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT spider_id FROM spider WHERE name = 'CH_VB'), 'CH_VB_013'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT spider_id FROM spider WHERE name = 'CH_VB'), 'CH_VB_014'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT spider_id FROM spider WHERE name = 'CH_VB'), 'CH_VB_015'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT spider_id FROM spider WHERE name = 'CH_VB'), 'CH_VB_016'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT spider_id FROM spider WHERE name = 'CH_VB'), 'CH_VB_017'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT spider_id FROM spider WHERE name = 'CH_VB'), 'CH_VB_018'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT spider_id FROM spider WHERE name = 'CH_VB'), 'CH_VB_019'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT spider_id FROM spider WHERE name = 'CH_VB'), 'CH_VB_020'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT spider_id FROM spider WHERE name = 'CH_VB'), 'CH_VB_021'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT spider_id FROM spider WHERE name = 'CH_VB'), 'CH_VB_022'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT spider_id FROM spider WHERE name = 'CH_VB'), 'CH_VB_023'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT spider_id FROM spider WHERE name = 'CH_VB'), 'CH_VB_024'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT spider_id FROM spider WHERE name = 'CH_VB'), 'CH_VB_025'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT spider_id FROM spider WHERE name = 'CH_VB'), 'CH_VB_026'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT spider_id FROM spider WHERE name = 'CH_VB'), 'CH_VB_027'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT spider_id FROM spider WHERE name = 'CH_VB'), 'CH_VB_028'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT spider_id FROM spider WHERE name = 'CH_VB'), 'CH_VB_029'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT spider_id FROM spider WHERE name = 'CH_VB'), 'CH_VB_030'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT spider_id FROM spider WHERE name = 'CH_VB'), 'CH_VB_031'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT spider_id FROM spider WHERE name = 'CH_VB'), 'CH_VB_032'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT spider_id FROM spider WHERE name = 'CH_VB'), 'CH_VB_033'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT spider_id FROM spider WHERE name = 'CH_VB'), 'CH_VB_034'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT spider_id FROM spider WHERE name = 'CH_VB'), 'CH_VB_035'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_VB'), (SELECT spider_id FROM spider WHERE name = 'CH_VB'), 'CH_VB_999'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_WBK'), (SELECT spider_id FROM spider WHERE name = 'CH_WEKO'), 'CH_WBK_001'),
    ((SELECT court_id FROM court WHERE court_string = 'CH_XX'), (SELECT spider_id FROM spider WHERE name = 'CH_BGer'), 'CH_XX_001'),
    ((SELECT court_id FROM court WHERE court_string = 'FR_TAMA'), (SELECT spider_id FROM spider WHERE name = 'FR_Gerichte'), 'FR_TAMA_001'),
    ((SELECT court_id FROM court WHERE court_string = 'FR_TC'), (SELECT spider_id FROM spider WHERE name = 'FR_Gerichte'), 'FR_TC_001'),
    ((SELECT court_id FROM court WHERE court_string = 'FR_TC'), (SELECT spider_id FROM spider WHERE name = 'FR_Gerichte'), 'FR_TC_003'),
    ((SELECT court_id FROM court WHERE court_string = 'FR_TC'), (SELECT spider_id FROM spider WHERE name = 'FR_Gerichte'), 'FR_TC_004'),
    ((SELECT court_id FROM court WHERE court_string = 'FR_TC'), (SELECT spider_id FROM spider WHERE name = 'FR_Gerichte'), 'FR_TC_005'),
    ((SELECT court_id FROM court WHERE court_string = 'FR_TC'), (SELECT spider_id FROM spider WHERE name = 'FR_Gerichte'), 'FR_TC_006'),
    ((SELECT court_id FROM court WHERE court_string = 'FR_TC'), (SELECT spider_id FROM spider WHERE name = 'FR_Gerichte'), 'FR_TC_007'),
    ((SELECT court_id FROM court WHERE court_string = 'FR_TC'), (SELECT spider_id FROM spider WHERE name = 'FR_Gerichte'), 'FR_TC_010'),
    ((SELECT court_id FROM court WHERE court_string = 'FR_TC'), (SELECT spider_id FROM spider WHERE name = 'FR_Gerichte'), 'FR_TC_011'),
    ((SELECT court_id FROM court WHERE court_string = 'FR_TC'), (SELECT spider_id FROM spider WHERE name = 'FR_Gerichte'), 'FR_TC_012'),
    ((SELECT court_id FROM court WHERE court_string = 'FR_TC'), (SELECT spider_id FROM spider WHERE name = 'FR_Gerichte'), 'FR_TC_999'),
    ((SELECT court_id FROM court WHERE court_string = 'FR_XX'), (SELECT spider_id FROM spider WHERE name = 'FR_Gerichte'), 'FR_XX_001'),
    ((SELECT court_id FROM court WHERE court_string = 'GE_CAPJ'), (SELECT spider_id FROM spider WHERE name = 'GE_Gerichte'), 'GE_CAPJ_001'),
    ((SELECT court_id FROM court WHERE court_string = 'GE_CJ'), (SELECT spider_id FROM spider WHERE name = 'GE_Gerichte'), 'GE_CJ_001'),
    ((SELECT court_id FROM court WHERE court_string = 'GE_CJ'), (SELECT spider_id FROM spider WHERE name = 'GE_Gerichte'), 'GE_CJ_002'),
    ((SELECT court_id FROM court WHERE court_string = 'GE_CJ'), (SELECT spider_id FROM spider WHERE name = 'GE_Gerichte'), 'GE_CJ_003'),
    ((SELECT court_id FROM court WHERE court_string = 'GE_CJ'), (SELECT spider_id FROM spider WHERE name = 'GE_Gerichte'), 'GE_CJ_004'),
    ((SELECT court_id FROM court WHERE court_string = 'GE_CJ'), (SELECT spider_id FROM spider WHERE name = 'GE_Gerichte'), 'GE_CJ_005'),
    ((SELECT court_id FROM court WHERE court_string = 'GE_CJ'), (SELECT spider_id FROM spider WHERE name = 'GE_Gerichte'), 'GE_CJ_006'),
    ((SELECT court_id FROM court WHERE court_string = 'GE_CJ'), (SELECT spider_id FROM spider WHERE name = 'GE_Gerichte'), 'GE_CJ_007'),
    ((SELECT court_id FROM court WHERE court_string = 'GE_CJ'), (SELECT spider_id FROM spider WHERE name = 'GE_Gerichte'), 'GE_CJ_008'),
    ((SELECT court_id FROM court WHERE court_string = 'GE_CJ'), (SELECT spider_id FROM spider WHERE name = 'GE_Gerichte'), 'GE_CJ_009'),
    ((SELECT court_id FROM court WHERE court_string = 'GE_CJ'), (SELECT spider_id FROM spider WHERE name = 'GE_Gerichte'), 'GE_CJ_010'),
    ((SELECT court_id FROM court WHERE court_string = 'GE_CJ'), (SELECT spider_id FROM spider WHERE name = 'GE_Gerichte'), 'GE_CJ_011'),
    ((SELECT court_id FROM court WHERE court_string = 'GE_CJ'), (SELECT spider_id FROM spider WHERE name = 'GE_Gerichte'), 'GE_CJ_012'),
    ((SELECT court_id FROM court WHERE court_string = 'GE_CJ'), (SELECT spider_id FROM spider WHERE name = 'GE_Gerichte'), 'GE_CJ_013'),
    ((SELECT court_id FROM court WHERE court_string = 'GE_CJ'), (SELECT spider_id FROM spider WHERE name = 'GE_Gerichte'), 'GE_CJ_014'),
    ((SELECT court_id FROM court WHERE court_string = 'GE_CJ'), (SELECT spider_id FROM spider WHERE name = 'GE_Gerichte'), 'GE_CJ_015'),
    ((SELECT court_id FROM court WHERE court_string = 'GE_CJ'), (SELECT spider_id FROM spider WHERE name = 'GE_Gerichte'), 'GE_CJ_999'),
    ((SELECT court_id FROM court WHERE court_string = 'GE_TAPI'), (SELECT spider_id FROM spider WHERE name = 'GE_Gerichte'), 'GE_TAPI_001'),
    ((SELECT court_id FROM court WHERE court_string = 'GE_TP'), (SELECT spider_id FROM spider WHERE name = 'GE_Gerichte'), 'GE_TP_001'),
    ((SELECT court_id FROM court WHERE court_string = 'GE_XX'), (SELECT spider_id FROM spider WHERE name = 'GE_Gerichte'), 'GE_XX_001'),
    ((SELECT court_id FROM court WHERE court_string = 'GL_KG'), (SELECT spider_id FROM spider WHERE name = 'GL_Omni'), 'GL_KG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'GL_KG'), (SELECT spider_id FROM spider WHERE name = 'GL_Omni'), 'GL_KG_002'),
    ((SELECT court_id FROM court WHERE court_string = 'GL_KG'), (SELECT spider_id FROM spider WHERE name = 'GL_Omni'), 'GL_KG_999'),
    ((SELECT court_id FROM court WHERE court_string = 'GL_OG'), (SELECT spider_id FROM spider WHERE name = 'GL_Omni'), 'GL_OG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'GL_VG'), (SELECT spider_id FROM spider WHERE name = 'GL_Omni'), 'GL_VG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'GL_XX'), (SELECT spider_id FROM spider WHERE name = 'GL_Omni'), 'GL_XX_999'),
    ((SELECT court_id FROM court WHERE court_string = 'GR_KG'), (SELECT spider_id FROM spider WHERE name = 'GR_Gerichte'), 'GR_KG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'GR_KG'), (SELECT spider_id FROM spider WHERE name = 'GR_Gerichte'), 'GR_KG_002'),
    ((SELECT court_id FROM court WHERE court_string = 'GR_KG'), (SELECT spider_id FROM spider WHERE name = 'GR_Gerichte'), 'GR_KG_003'),
    ((SELECT court_id FROM court WHERE court_string = 'GR_KG'), (SELECT spider_id FROM spider WHERE name = 'GR_Gerichte'), 'GR_KG_004'),
    ((SELECT court_id FROM court WHERE court_string = 'GR_KG'), (SELECT spider_id FROM spider WHERE name = 'GR_Gerichte'), 'GR_KG_005'),
    ((SELECT court_id FROM court WHERE court_string = 'GR_KG'), (SELECT spider_id FROM spider WHERE name = 'GR_Gerichte'), 'GR_KG_006'),
    ((SELECT court_id FROM court WHERE court_string = 'GR_KG'), (SELECT spider_id FROM spider WHERE name = 'GR_Gerichte'), 'GR_KG_007'),
    ((SELECT court_id FROM court WHERE court_string = 'GR_KG'), (SELECT spider_id FROM spider WHERE name = 'GR_Gerichte'), 'GR_KG_010'),
    ((SELECT court_id FROM court WHERE court_string = 'GR_KG'), (SELECT spider_id FROM spider WHERE name = 'GR_Gerichte'), 'GR_KG_012'),
    ((SELECT court_id FROM court WHERE court_string = 'GR_KG'), (SELECT spider_id FROM spider WHERE name = 'GR_Gerichte'), 'GR_KG_999'),
    ((SELECT court_id FROM court WHERE court_string = 'GR_VG'), (SELECT spider_id FROM spider WHERE name = 'GR_Gerichte'), 'GR_VG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'GR_VG'), (SELECT spider_id FROM spider WHERE name = 'GR_Gerichte'), 'GR_VG_002'),
    ((SELECT court_id FROM court WHERE court_string = 'GR_VG'), (SELECT spider_id FROM spider WHERE name = 'GR_Gerichte'), 'GR_VG_003'),
    ((SELECT court_id FROM court WHERE court_string = 'GR_VG'), (SELECT spider_id FROM spider WHERE name = 'GR_Gerichte'), 'GR_VG_004'),
    ((SELECT court_id FROM court WHERE court_string = 'GR_VG'), (SELECT spider_id FROM spider WHERE name = 'GR_Gerichte'), 'GR_VG_005'),
    ((SELECT court_id FROM court WHERE court_string = 'GR_VG'), (SELECT spider_id FROM spider WHERE name = 'GR_Gerichte'), 'GR_VG_006'),
    ((SELECT court_id FROM court WHERE court_string = 'GR_VG'), (SELECT spider_id FROM spider WHERE name = 'GR_Gerichte'), 'GR_VG_999'),
    ((SELECT court_id FROM court WHERE court_string = 'GR_XX'), (SELECT spider_id FROM spider WHERE name = 'GR_Gerichte'), 'GR_XX_001'),
    ((SELECT court_id FROM court WHERE court_string = 'JU_TC'), (SELECT spider_id FROM spider WHERE name = 'JU_Gerichte'), 'JU_TC_001'),
    ((SELECT court_id FROM court WHERE court_string = 'JU_TC'), (SELECT spider_id FROM spider WHERE name = 'JU_Gerichte'), 'JU_TC_002'),
    ((SELECT court_id FROM court WHERE court_string = 'JU_TC'), (SELECT spider_id FROM spider WHERE name = 'JU_Gerichte'), 'JU_TC_003'),
    ((SELECT court_id FROM court WHERE court_string = 'JU_TC'), (SELECT spider_id FROM spider WHERE name = 'JU_Gerichte'), 'JU_TC_004'),
    ((SELECT court_id FROM court WHERE court_string = 'JU_TC'), (SELECT spider_id FROM spider WHERE name = 'JU_Gerichte'), 'JU_TC_005'),
    ((SELECT court_id FROM court WHERE court_string = 'JU_TC'), (SELECT spider_id FROM spider WHERE name = 'JU_Gerichte'), 'JU_TC_006'),
    ((SELECT court_id FROM court WHERE court_string = 'JU_TC'), (SELECT spider_id FROM spider WHERE name = 'JU_Gerichte'), 'JU_TC_007'),
    ((SELECT court_id FROM court WHERE court_string = 'JU_TC'), (SELECT spider_id FROM spider WHERE name = 'JU_Gerichte'), 'JU_TC_008'),
    ((SELECT court_id FROM court WHERE court_string = 'JU_TC'), (SELECT spider_id FROM spider WHERE name = 'JU_Gerichte'), 'JU_TC_009'),
    ((SELECT court_id FROM court WHERE court_string = 'JU_TC'), (SELECT spider_id FROM spider WHERE name = 'JU_Gerichte'), 'JU_TC_010'),
    ((SELECT court_id FROM court WHERE court_string = 'JU_TC'), (SELECT spider_id FROM spider WHERE name = 'JU_Gerichte'), 'JU_TC_011'),
    ((SELECT court_id FROM court WHERE court_string = 'JU_TC'), (SELECT spider_id FROM spider WHERE name = 'JU_Gerichte'), 'JU_TC_999'),
    ((SELECT court_id FROM court WHERE court_string = 'JU_TPI'), (SELECT spider_id FROM spider WHERE name = 'JU_Gerichte'), 'JU_TPI_006'),
    ((SELECT court_id FROM court WHERE court_string = 'JU_TPI'), (SELECT spider_id FROM spider WHERE name = 'JU_Gerichte'), 'JU_TPI_007'),
    ((SELECT court_id FROM court WHERE court_string = 'JU_TPI'), (SELECT spider_id FROM spider WHERE name = 'JU_Gerichte'), 'JU_TPI_999'),
    ((SELECT court_id FROM court WHERE court_string = 'JU_XX'), (SELECT spider_id FROM spider WHERE name = 'JU_Gerichte'), 'JU_XX_001'),
    ((SELECT court_id FROM court WHERE court_string = 'LU_AUK'), (SELECT spider_id FROM spider WHERE name = 'LU_Gerichte'), 'LU_AUK_001'),
    ((SELECT court_id FROM court WHERE court_string = 'LU_BKD'), (SELECT spider_id FROM spider WHERE name = 'LU_Gerichte'), 'LU_BKD_001'),
    ((SELECT court_id FROM court WHERE court_string = 'LU_BZG'), (SELECT spider_id FROM spider WHERE name = 'LU_Gerichte'), 'LU_BZG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'LU_GSD'), (SELECT spider_id FROM spider WHERE name = 'LU_Gerichte'), 'LU_GSD_001'),
    ((SELECT court_id FROM court WHERE court_string = 'LU_JSD'), (SELECT spider_id FROM spider WHERE name = 'LU_Gerichte'), 'LU_JSD_001'),
    ((SELECT court_id FROM court WHERE court_string = 'LU_KG'), (SELECT spider_id FROM spider WHERE name = 'LU_Gerichte'), 'LU_KG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'LU_KG'), (SELECT spider_id FROM spider WHERE name = 'LU_Gerichte'), 'LU_KG_002'),
    ((SELECT court_id FROM court WHERE court_string = 'LU_KG'), (SELECT spider_id FROM spider WHERE name = 'LU_Gerichte'), 'LU_KG_003'),
    ((SELECT court_id FROM court WHERE court_string = 'LU_KG'), (SELECT spider_id FROM spider WHERE name = 'LU_Gerichte'), 'LU_KG_004'),
    ((SELECT court_id FROM court WHERE court_string = 'LU_KG'), (SELECT spider_id FROM spider WHERE name = 'LU_Gerichte'), 'LU_KG_005'),
    ((SELECT court_id FROM court WHERE court_string = 'LU_KG'), (SELECT spider_id FROM spider WHERE name = 'LU_Gerichte'), 'LU_KG_999'),
    ((SELECT court_id FROM court WHERE court_string = 'LU_RR'), (SELECT spider_id FROM spider WHERE name = 'LU_Gerichte'), 'LU_RR_001'),
    ((SELECT court_id FROM court WHERE court_string = 'LU_RSH'), (SELECT spider_id FROM spider WHERE name = 'LU_Gerichte'), 'LU_RSH_001'),
    ((SELECT court_id FROM court WHERE court_string = 'LU_XX'), (SELECT spider_id FROM spider WHERE name = 'LU_Gerichte'), 'LU_XX_001'),
    ((SELECT court_id FROM court WHERE court_string = 'NE_ARA'), (SELECT spider_id FROM spider WHERE name = 'NE_Omni'), 'NE_ARA_001'),
    ((SELECT court_id FROM court WHERE court_string = 'NE_ASL'), (SELECT spider_id FROM spider WHERE name = 'NE_Omni'), 'NE_ASL_001'),
    ((SELECT court_id FROM court WHERE court_string = 'NE_ASS'), (SELECT spider_id FROM spider WHERE name = 'NE_Omni'), 'NE_ASS_001'),
    ((SELECT court_id FROM court WHERE court_string = 'NE_ATS'), (SELECT spider_id FROM spider WHERE name = 'NE_Omni'), 'NE_ATS_001'),
    ((SELECT court_id FROM court WHERE court_string = 'NE_CA'), (SELECT spider_id FROM spider WHERE name = 'NE_Omni'), 'NE_CA_001'),
    ((SELECT court_id FROM court WHERE court_string = 'NE_CN'), (SELECT spider_id FROM spider WHERE name = 'NE_Omni'), 'NE_CN_001'),
    ((SELECT court_id FROM court WHERE court_string = 'NE_TC'), (SELECT spider_id FROM spider WHERE name = 'NE_Omni'), 'NE_TC_001'),
    ((SELECT court_id FROM court WHERE court_string = 'NE_TC'), (SELECT spider_id FROM spider WHERE name = 'NE_Omni'), 'NE_TC_002'),
    ((SELECT court_id FROM court WHERE court_string = 'NE_TC'), (SELECT spider_id FROM spider WHERE name = 'NE_Omni'), 'NE_TC_003'),
    ((SELECT court_id FROM court WHERE court_string = 'NE_TC'), (SELECT spider_id FROM spider WHERE name = 'NE_Omni'), 'NE_TC_004'),
    ((SELECT court_id FROM court WHERE court_string = 'NE_TC'), (SELECT spider_id FROM spider WHERE name = 'NE_Omni'), 'NE_TC_005'),
    ((SELECT court_id FROM court WHERE court_string = 'NE_TC'), (SELECT spider_id FROM spider WHERE name = 'NE_Omni'), 'NE_TC_006'),
    ((SELECT court_id FROM court WHERE court_string = 'NE_TC'), (SELECT spider_id FROM spider WHERE name = 'NE_Omni'), 'NE_TC_007'),
    ((SELECT court_id FROM court WHERE court_string = 'NE_TC'), (SELECT spider_id FROM spider WHERE name = 'NE_Omni'), 'NE_TC_008'),
    ((SELECT court_id FROM court WHERE court_string = 'NE_TC'), (SELECT spider_id FROM spider WHERE name = 'NE_Omni'), 'NE_TC_009'),
    ((SELECT court_id FROM court WHERE court_string = 'NE_TC'), (SELECT spider_id FROM spider WHERE name = 'NE_Omni'), 'NE_TC_010'),
    ((SELECT court_id FROM court WHERE court_string = 'NE_TC'), (SELECT spider_id FROM spider WHERE name = 'NE_Omni'), 'NE_TC_011'),
    ((SELECT court_id FROM court WHERE court_string = 'NE_TC'), (SELECT spider_id FROM spider WHERE name = 'NE_Omni'), 'NE_TC_012'),
    ((SELECT court_id FROM court WHERE court_string = 'NE_TC'), (SELECT spider_id FROM spider WHERE name = 'NE_Omni'), 'NE_TC_013'),
    ((SELECT court_id FROM court WHERE court_string = 'NE_TC'), (SELECT spider_id FROM spider WHERE name = 'NE_Omni'), 'NE_TC_014'),
    ((SELECT court_id FROM court WHERE court_string = 'NE_TC'), (SELECT spider_id FROM spider WHERE name = 'NE_Omni'), 'NE_TC_015'),
    ((SELECT court_id FROM court WHERE court_string = 'NE_TC'), (SELECT spider_id FROM spider WHERE name = 'NE_Omni'), 'NE_TC_999'),
    ((SELECT court_id FROM court WHERE court_string = 'NE_TR'), (SELECT spider_id FROM spider WHERE name = 'NE_Omni'), 'NE_TR_001'),
    ((SELECT court_id FROM court WHERE court_string = 'NE_TR'), (SELECT spider_id FROM spider WHERE name = 'NE_Omni'), 'NE_TR_002'),
    ((SELECT court_id FROM court WHERE court_string = 'NE_TR'), (SELECT spider_id FROM spider WHERE name = 'NE_Omni'), 'NE_TR_999'),
    ((SELECT court_id FROM court WHERE court_string = 'NE_XX'), (SELECT spider_id FROM spider WHERE name = 'NE_Omni'), 'NE_XX_001'),
    ((SELECT court_id FROM court WHERE court_string = 'NW_OG'), (SELECT spider_id FROM spider WHERE name = 'NW_Gerichte'), 'NW_OG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'NW_XX'), (SELECT spider_id FROM spider WHERE name = 'NW_Gerichte'), 'NW_XX_001'),
    ((SELECT court_id FROM court WHERE court_string = 'OW_OG'), (SELECT spider_id FROM spider WHERE name = 'OW_Gerichte'), 'OW_OG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'OW_VB'), (SELECT spider_id FROM spider WHERE name = 'OW_Gerichte'), 'OW_VB_001'),
    ((SELECT court_id FROM court WHERE court_string = 'OW_VG'), (SELECT spider_id FROM spider WHERE name = 'OW_Gerichte'), 'OW_VG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'OW_XX'), (SELECT spider_id FROM spider WHERE name = 'OW_Gerichte'), 'OW_XX_001'),
    ((SELECT court_id FROM court WHERE court_string = 'SG_ABSK'), (SELECT spider_id FROM spider WHERE name = 'SG_Gerichte'), 'SG_ABSK_001'),
    ((SELECT court_id FROM court WHERE court_string = 'SG_HG'), (SELECT spider_id FROM spider WHERE name = 'SG_Gerichte'), 'SG_HG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'SG_KG'), (SELECT spider_id FROM spider WHERE name = 'SG_Gerichte'), 'SG_KG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'SG_KG'), (SELECT spider_id FROM spider WHERE name = 'SG_Gerichte'), 'SG_KG_002'),
    ((SELECT court_id FROM court WHERE court_string = 'SG_KG'), (SELECT spider_id FROM spider WHERE name = 'SG_Gerichte'), 'SG_KG_003'),
    ((SELECT court_id FROM court WHERE court_string = 'SG_KG'), (SELECT spider_id FROM spider WHERE name = 'SG_Gerichte'), 'SG_KG_999'),
    ((SELECT court_id FROM court WHERE court_string = 'SG_KGN'), (SELECT spider_id FROM spider WHERE name = 'SG_Publikationen'), 'SG_KGN_001'),
    ((SELECT court_id FROM court WHERE court_string = 'SG_KGN'), (SELECT spider_id FROM spider WHERE name = 'SG_Publikationen'), 'SG_KGN_999'),
    ((SELECT court_id FROM court WHERE court_string = 'SG_VB'), (SELECT spider_id FROM spider WHERE name = 'SG_Publikationen'), 'SG_VB_001'),
    ((SELECT court_id FROM court WHERE court_string = 'SG_VB'), (SELECT spider_id FROM spider WHERE name = 'SG_Publikationen'), 'SG_VB_002'),
    ((SELECT court_id FROM court WHERE court_string = 'SG_VB'), (SELECT spider_id FROM spider WHERE name = 'SG_Publikationen'), 'SG_VB_999'),
    ((SELECT court_id FROM court WHERE court_string = 'SG_VG'), (SELECT spider_id FROM spider WHERE name = 'SG_Gerichte'), 'SG_VG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'SG_VGN'), (SELECT spider_id FROM spider WHERE name = 'SG_Publikationen'), 'SG_VGN_001'),
    ((SELECT court_id FROM court WHERE court_string = 'SG_VSG'), (SELECT spider_id FROM spider WHERE name = 'SG_Gerichte'), 'SG_VSG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'SG_VWEK'), (SELECT spider_id FROM spider WHERE name = 'SG_Gerichte'), 'SG_VWEK_001'),
    ((SELECT court_id FROM court WHERE court_string = 'SG_XX'), (SELECT spider_id FROM spider WHERE name = 'SG_Gerichte'), 'SG_XX_001'),
    ((SELECT court_id FROM court WHERE court_string = 'SH_OG'), (SELECT spider_id FROM spider WHERE name = 'SH_OG'), 'SH_OG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'SH_XX'), (SELECT spider_id FROM spider WHERE name = 'SH_OG'), 'SH_XX_001'),
    ((SELECT court_id FROM court WHERE court_string = 'SO_OG'), (SELECT spider_id FROM spider WHERE name = 'SO_Omni'), 'SO_OG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'SO_OG'), (SELECT spider_id FROM spider WHERE name = 'SO_Omni'), 'SO_OG_002'),
    ((SELECT court_id FROM court WHERE court_string = 'SO_OG'), (SELECT spider_id FROM spider WHERE name = 'SO_Omni'), 'SO_OG_003'),
    ((SELECT court_id FROM court WHERE court_string = 'SO_OG'), (SELECT spider_id FROM spider WHERE name = 'SO_Omni'), 'SO_OG_004'),
    ((SELECT court_id FROM court WHERE court_string = 'SO_OG'), (SELECT spider_id FROM spider WHERE name = 'SO_Omni'), 'SO_OG_005'),
    ((SELECT court_id FROM court WHERE court_string = 'SO_OG'), (SELECT spider_id FROM spider WHERE name = 'SO_Omni'), 'SO_OG_006'),
    ((SELECT court_id FROM court WHERE court_string = 'SO_OG'), (SELECT spider_id FROM spider WHERE name = 'SO_Omni'), 'SO_OG_999'),
    ((SELECT court_id FROM court WHERE court_string = 'SO_SK'), (SELECT spider_id FROM spider WHERE name = 'SO_Omni'), 'SO_SK_001'),
    ((SELECT court_id FROM court WHERE court_string = 'SO_STG'), (SELECT spider_id FROM spider WHERE name = 'SO_Omni'), 'SO_STG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'SO_VG'), (SELECT spider_id FROM spider WHERE name = 'SO_Omni'), 'SO_VG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'SO_VSG'), (SELECT spider_id FROM spider WHERE name = 'SO_Omni'), 'SO_VSG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'SO_XX'), (SELECT spider_id FROM spider WHERE name = 'SO_Omni'), 'SO_XX_001'),
    ((SELECT court_id FROM court WHERE court_string = 'SZ_KG'), (SELECT spider_id FROM spider WHERE name = 'SZ_Gerichte'), 'SZ_KG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'SZ_KG'), (SELECT spider_id FROM spider WHERE name = 'SZ_Gerichte'), 'SZ_KG_002'),
    ((SELECT court_id FROM court WHERE court_string = 'SZ_KG'), (SELECT spider_id FROM spider WHERE name = 'SZ_Gerichte'), 'SZ_KG_003'),
    ((SELECT court_id FROM court WHERE court_string = 'SZ_KG'), (SELECT spider_id FROM spider WHERE name = 'SZ_Gerichte'), 'SZ_KG_004'),
    ((SELECT court_id FROM court WHERE court_string = 'SZ_KG'), (SELECT spider_id FROM spider WHERE name = 'SZ_Gerichte'), 'SZ_KG_999'),
    ((SELECT court_id FROM court WHERE court_string = 'SZ_XX'), (SELECT spider_id FROM spider WHERE name = 'SZ_Gerichte'), 'SZ_XX_001'),
    ((SELECT court_id FROM court WHERE court_string = 'TG_OG'), (SELECT spider_id FROM spider WHERE name = 'TG_OG'), 'TG_OG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'TG_XX'), (SELECT spider_id FROM spider WHERE name = 'TG_OG'), 'TG_XX_001'),
    ((SELECT court_id FROM court WHERE court_string = 'TI_CARP'), (SELECT spider_id FROM spider WHERE name = 'TI_Gerichte'), 'TI_CARP_001'),
    ((SELECT court_id FROM court WHERE court_string = 'TI_CATI'), (SELECT spider_id FROM spider WHERE name = 'TI_Gerichte'), 'TI_CATI_001'),
    ((SELECT court_id FROM court WHERE court_string = 'TI_CRP'), (SELECT spider_id FROM spider WHERE name = 'TI_Gerichte'), 'TI_CRP_001'),
    ((SELECT court_id FROM court WHERE court_string = 'TI_GIAR'), (SELECT spider_id FROM spider WHERE name = 'TI_Gerichte'), 'TI_GIAR_001'),
    ((SELECT court_id FROM court WHERE court_string = 'TI_GPC'), (SELECT spider_id FROM spider WHERE name = 'TI_Gerichte'), 'TI_GPC_001'),
    ((SELECT court_id FROM court WHERE court_string = 'TI_PP'), (SELECT spider_id FROM spider WHERE name = 'TI_Gerichte'), 'TI_PP_001'),
    ((SELECT court_id FROM court WHERE court_string = 'TI_TCA'), (SELECT spider_id FROM spider WHERE name = 'TI_Gerichte'), 'TI_TCA_001'),
    ((SELECT court_id FROM court WHERE court_string = 'TI_TCAS'), (SELECT spider_id FROM spider WHERE name = 'TI_Gerichte'), 'TI_TCAS_001'),
    ((SELECT court_id FROM court WHERE court_string = 'TI_TE'), (SELECT spider_id FROM spider WHERE name = 'TI_Gerichte'), 'TI_TE_001'),
    ((SELECT court_id FROM court WHERE court_string = 'TI_TPC'), (SELECT spider_id FROM spider WHERE name = 'TI_Gerichte'), 'TI_TPC_001'),
    ((SELECT court_id FROM court WHERE court_string = 'TI_TRAC'), (SELECT spider_id FROM spider WHERE name = 'TI_Gerichte'), 'TI_TRAC_001'),
    ((SELECT court_id FROM court WHERE court_string = 'TI_TRAC'), (SELECT spider_id FROM spider WHERE name = 'TI_Gerichte'), 'TI_TRAC_002'),
    ((SELECT court_id FROM court WHERE court_string = 'TI_TRAC'), (SELECT spider_id FROM spider WHERE name = 'TI_Gerichte'), 'TI_TRAC_003'),
    ((SELECT court_id FROM court WHERE court_string = 'TI_TRAC'), (SELECT spider_id FROM spider WHERE name = 'TI_Gerichte'), 'TI_TRAC_004'),
    ((SELECT court_id FROM court WHERE court_string = 'TI_TRAC'), (SELECT spider_id FROM spider WHERE name = 'TI_Gerichte'), 'TI_TRAC_005'),
    ((SELECT court_id FROM court WHERE court_string = 'TI_TRAC'), (SELECT spider_id FROM spider WHERE name = 'TI_Gerichte'), 'TI_TRAC_006'),
    ((SELECT court_id FROM court WHERE court_string = 'TI_TRAC'), (SELECT spider_id FROM spider WHERE name = 'TI_Gerichte'), 'TI_TRAC_007'),
    ((SELECT court_id FROM court WHERE court_string = 'TI_TRAC'), (SELECT spider_id FROM spider WHERE name = 'TI_Gerichte'), 'TI_TRAC_999'),
    ((SELECT court_id FROM court WHERE court_string = 'TI_TRAP'), (SELECT spider_id FROM spider WHERE name = 'TI_Gerichte'), 'TI_TRAP_001'),
    ((SELECT court_id FROM court WHERE court_string = 'TI_TRAP'), (SELECT spider_id FROM spider WHERE name = 'TI_Gerichte'), 'TI_TRAP_002'),
    ((SELECT court_id FROM court WHERE court_string = 'TI_TRAP'), (SELECT spider_id FROM spider WHERE name = 'TI_Gerichte'), 'TI_TRAP_999'),
    ((SELECT court_id FROM court WHERE court_string = 'TI_TRPI'), (SELECT spider_id FROM spider WHERE name = 'TI_Gerichte'), 'TI_TRPI_001'),
    ((SELECT court_id FROM court WHERE court_string = 'TI_XX'), (SELECT spider_id FROM spider WHERE name = 'TI_Gerichte'), 'TI_XX_999'),
    ((SELECT court_id FROM court WHERE court_string = 'UR_REB'), (SELECT spider_id FROM spider WHERE name = 'UR_Gerichte'), 'UR_REB_001'),
    ((SELECT court_id FROM court WHERE court_string = 'UR_XX'), (SELECT spider_id FROM spider WHERE name = 'UR_Gerichte'), 'UR_XX_001'),
    ((SELECT court_id FROM court WHERE court_string = 'VD_SR'), (SELECT spider_id FROM spider WHERE name = 'VD_Omni'), 'VD_SR_001'),
    ((SELECT court_id FROM court WHERE court_string = 'VD_TC'), (SELECT spider_id FROM spider WHERE name = 'VD_FindInfo'), 'VD_TC_001'),
    ((SELECT court_id FROM court WHERE court_string = 'VD_TC'), (SELECT spider_id FROM spider WHERE name = 'VD_FindInfo'), 'VD_TC_002'),
    ((SELECT court_id FROM court WHERE court_string = 'VD_TC'), (SELECT spider_id FROM spider WHERE name = 'VD_FindInfo'), 'VD_TC_003'),
    ((SELECT court_id FROM court WHERE court_string = 'VD_TC'), (SELECT spider_id FROM spider WHERE name = 'VD_FindInfo'), 'VD_TC_004'),
    ((SELECT court_id FROM court WHERE court_string = 'VD_TC'), (SELECT spider_id FROM spider WHERE name = 'VD_FindInfo'), 'VD_TC_005'),
    ((SELECT court_id FROM court WHERE court_string = 'VD_TC'), (SELECT spider_id FROM spider WHERE name = 'VD_FindInfo'), 'VD_TC_006'),
    ((SELECT court_id FROM court WHERE court_string = 'VD_TC'), (SELECT spider_id FROM spider WHERE name = 'VD_FindInfo'), 'VD_TC_007'),
    ((SELECT court_id FROM court WHERE court_string = 'VD_TC'), (SELECT spider_id FROM spider WHERE name = 'VD_FindInfo'), 'VD_TC_008'),
    ((SELECT court_id FROM court WHERE court_string = 'VD_TC'), (SELECT spider_id FROM spider WHERE name = 'VD_FindInfo'), 'VD_TC_009'),
    ((SELECT court_id FROM court WHERE court_string = 'VD_TC'), (SELECT spider_id FROM spider WHERE name = 'VD_FindInfo'), 'VD_TC_010'),
    ((SELECT court_id FROM court WHERE court_string = 'VD_TC'), (SELECT spider_id FROM spider WHERE name = 'VD_FindInfo'), 'VD_TC_013'),
    ((SELECT court_id FROM court WHERE court_string = 'VD_TC'), (SELECT spider_id FROM spider WHERE name = 'VD_FindInfo'), 'VD_TC_014'),
    ((SELECT court_id FROM court WHERE court_string = 'VD_TC'), (SELECT spider_id FROM spider WHERE name = 'VD_FindInfo'), 'VD_TC_015'),
    ((SELECT court_id FROM court WHERE court_string = 'VD_TC'), (SELECT spider_id FROM spider WHERE name = 'VD_FindInfo'), 'VD_TC_016'),
    ((SELECT court_id FROM court WHERE court_string = 'VD_TC'), (SELECT spider_id FROM spider WHERE name = 'VD_FindInfo'), 'VD_TC_017'),
    ((SELECT court_id FROM court WHERE court_string = 'VD_TC'), (SELECT spider_id FROM spider WHERE name = 'VD_FindInfo'), 'VD_TC_018'),
    ((SELECT court_id FROM court WHERE court_string = 'VD_TC'), (SELECT spider_id FROM spider WHERE name = 'VD_FindInfo'), 'VD_TC_019'),
    ((SELECT court_id FROM court WHERE court_string = 'VD_TC'), (SELECT spider_id FROM spider WHERE name = 'VD_FindInfo'), 'VD_TC_020'),
    ((SELECT court_id FROM court WHERE court_string = 'VD_TC'), (SELECT spider_id FROM spider WHERE name = 'VD_Omni'), 'VD_TC_030'),
    ((SELECT court_id FROM court WHERE court_string = 'VD_TC'), (SELECT spider_id FROM spider WHERE name = 'VD_Omni'), 'VD_TC_031'),
    ((SELECT court_id FROM court WHERE court_string = 'VD_TC'), (SELECT spider_id FROM spider WHERE name = 'VD_Omni'), 'VD_TC_032'),
    ((SELECT court_id FROM court WHERE court_string = 'VD_TC'), (SELECT spider_id FROM spider WHERE name = 'VD_Omni'), 'VD_TC_999'),
    ((SELECT court_id FROM court WHERE court_string = 'VD_TN'), (SELECT spider_id FROM spider WHERE name = 'VD_Omni'), 'VD_TN_001'),
    ((SELECT court_id FROM court WHERE court_string = 'VD_TPHA'), (SELECT spider_id FROM spider WHERE name = 'VD_FindInfo'), 'VD_TPHA_001'),
    ((SELECT court_id FROM court WHERE court_string = 'VD_XX'), (SELECT spider_id FROM spider WHERE name = 'VD_FindInfo'), 'VD_XX_001'),
    ((SELECT court_id FROM court WHERE court_string = 'VS_AG'), (SELECT spider_id FROM spider WHERE name = 'VS_Gerichte'), 'VS_AG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'VS_BZG'), (SELECT spider_id FROM spider WHERE name = 'VS_Gerichte'), 'VS_BZG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'VS_BZG'), (SELECT spider_id FROM spider WHERE name = 'VS_Gerichte'), 'VS_BZG_002'),
    ((SELECT court_id FROM court WHERE court_string = 'VS_BZG'), (SELECT spider_id FROM spider WHERE name = 'VS_Gerichte'), 'VS_BZG_003'),
    ((SELECT court_id FROM court WHERE court_string = 'VS_BZG'), (SELECT spider_id FROM spider WHERE name = 'VS_Gerichte'), 'VS_BZG_004'),
    ((SELECT court_id FROM court WHERE court_string = 'VS_BZG'), (SELECT spider_id FROM spider WHERE name = 'VS_Gerichte'), 'VS_BZG_005'),
    ((SELECT court_id FROM court WHERE court_string = 'VS_BZG'), (SELECT spider_id FROM spider WHERE name = 'VS_Gerichte'), 'VS_BZG_006'),
    ((SELECT court_id FROM court WHERE court_string = 'VS_BZG'), (SELECT spider_id FROM spider WHERE name = 'VS_Gerichte'), 'VS_BZG_007'),
    ((SELECT court_id FROM court WHERE court_string = 'VS_BZG'), (SELECT spider_id FROM spider WHERE name = 'VS_Gerichte'), 'VS_BZG_008'),
    ((SELECT court_id FROM court WHERE court_string = 'VS_BZG'), (SELECT spider_id FROM spider WHERE name = 'VS_Gerichte'), 'VS_BZG_009'),
    ((SELECT court_id FROM court WHERE court_string = 'VS_BZG'), (SELECT spider_id FROM spider WHERE name = 'VS_Gerichte'), 'VS_BZG_999'),
    ((SELECT court_id FROM court WHERE court_string = 'VS_SRK'), (SELECT spider_id FROM spider WHERE name = 'VS_Gerichte'), 'VS_SRK_001'),
    ((SELECT court_id FROM court WHERE court_string = 'VS_TC'), (SELECT spider_id FROM spider WHERE name = 'VS_Gerichte'), 'VS_TC_001'),
    ((SELECT court_id FROM court WHERE court_string = 'VS_XX'), (SELECT spider_id FROM spider WHERE name = 'VS_Gerichte'), 'VS_XX_001'),
    ((SELECT court_id FROM court WHERE court_string = 'ZG_VG'), (SELECT spider_id FROM spider WHERE name = 'ZG_Verwaltungsgericht'), 'ZG_VG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'ZG_VG'), (SELECT spider_id FROM spider WHERE name = 'ZG_Verwaltungsgericht'), 'ZG_VG_002'),
    ((SELECT court_id FROM court WHERE court_string = 'ZG_VG'), (SELECT spider_id FROM spider WHERE name = 'ZG_Verwaltungsgericht'), 'ZG_VG_003'),
    ((SELECT court_id FROM court WHERE court_string = 'ZG_VG'), (SELECT spider_id FROM spider WHERE name = 'ZG_Verwaltungsgericht'), 'ZG_VG_004'),
    ((SELECT court_id FROM court WHERE court_string = 'ZG_VG'), (SELECT spider_id FROM spider WHERE name = 'ZG_Verwaltungsgericht'), 'ZG_VG_999'),
    ((SELECT court_id FROM court WHERE court_string = 'ZG_XX'), (SELECT spider_id FROM spider WHERE name = 'ZG_Verwaltungsgericht'), 'ZG_XX_001'),
    ((SELECT court_id FROM court WHERE court_string = 'ZH_BK'), (SELECT spider_id FROM spider WHERE name = 'ZH_Obergericht'), 'ZH_BK_004'),
    ((SELECT court_id FROM court WHERE court_string = 'ZH_BRK'), (SELECT spider_id FROM spider WHERE name = 'ZH_Baurekurs'), 'ZH_BRK_001'),
    ((SELECT court_id FROM court WHERE court_string = 'ZH_HG'), (SELECT spider_id FROM spider WHERE name = 'ZH_Obergericht'), 'ZH_HG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'ZH_KSG'), (SELECT spider_id FROM spider WHERE name = 'ZH_Obergericht'), 'ZH_KSG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'ZH_OG'), (SELECT spider_id FROM spider WHERE name = 'ZH_Obergericht'), 'ZH_OG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'ZH_OG'), (SELECT spider_id FROM spider WHERE name = 'ZH_Obergericht'), 'ZH_OG_002'),
    ((SELECT court_id FROM court WHERE court_string = 'ZH_OG'), (SELECT spider_id FROM spider WHERE name = 'ZH_Obergericht'), 'ZH_OG_003'),
    ((SELECT court_id FROM court WHERE court_string = 'ZH_OG'), (SELECT spider_id FROM spider WHERE name = 'ZH_Obergericht'), 'ZH_OG_004'),
    ((SELECT court_id FROM court WHERE court_string = 'ZH_OG'), (SELECT spider_id FROM spider WHERE name = 'ZH_Obergericht'), 'ZH_OG_005'),
    ((SELECT court_id FROM court WHERE court_string = 'ZH_OG'), (SELECT spider_id FROM spider WHERE name = 'ZH_Obergericht'), 'ZH_OG_999'),
    ((SELECT court_id FROM court WHERE court_string = 'ZH_SOBE'), (SELECT spider_id FROM spider WHERE name = 'ZH_Obergericht'), 'ZH_SOBE_001'),
    ((SELECT court_id FROM court WHERE court_string = 'ZH_SRK'), (SELECT spider_id FROM spider WHERE name = 'ZH_Steuerrekurs'), 'ZH_SRK_001'),
    ((SELECT court_id FROM court WHERE court_string = 'ZH_SVG'), (SELECT spider_id FROM spider WHERE name = 'ZH_Sozialversicherungsgericht'), 'ZH_SVG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'ZH_VG'), (SELECT spider_id FROM spider WHERE name = 'ZH_Verwaltungsgericht'), 'ZH_VG_001'),
    ((SELECT court_id FROM court WHERE court_string = 'ZH_XX'), (SELECT spider_id FROM spider WHERE name = 'ZH_Obergericht'), 'ZH_XX_001')
;

INSERT INTO judgement("text") VALUES
    ('approval'),
    ('dismissal'),
    ('inadmissible'),
    ('partial_approval'),
    ('partial_dismissal'),
    ('unification'),
    ('write_off')
;

INSERT INTO citation_type(citation_type_name) VALUES 
    ('ruling'),
    ('law'),
    ('commentary')
;

INSERT INTO section_type("name") VALUES 
    ('full_text'),
    ('header'),
    ('facts'),
    ('considerations'),
    ('rulings'),
    ('footer')
;

INSERT INTO judicial_person_type("name") VALUES 
    ('federal_judge'),
    ('deputy_federal_judge'),
    ('clerk')
;

INSERT INTO party_type("name") VALUES 
    ('plaintiff'),
    ('defendant'),
    ('representation_plaintiff'),
    ('representation_defendant')
;