# Diversifying Deep Ensembles: A Saliency Map Approach for Enhanced OOD Detection, Calibration, and Accuracy

This repository is a fork of the public [OpenOOD](https://github.com/Jingkang50/OpenOOD) repository.
Here we present a brief outline on reproducing the key results of our paper.

The source code of SDDE method along with baselines is located in
`openood/trainers/deed_trainer.py`

## How to prepare the environment

There are two options:

1. Build Miniconda environment from `./environment.yml`.
2. Build Docker image from `./Dockerfile` (it builds the same environment inside the image).

Do not forget to download the data before running the code:
```shell
bash ./scripts/download/dowanload.sh
```

## How to reproduce the results

As we use [wandb](https://wandb.ai/) as a monitoring tool, you will need to set wandb environment variables:

```shell
unset WANDB_RUN_ID
unset WANDB_BASE_URL
export WANDB_API_KEY=<KEY>
export WANDB_ENTITY=<ENTITY>
```

**Note**: run all the scripts below from the repository root.

**Note**: all the experiments on `cifar10`, `cifar100`, `mnist` are guaranteed to run on a single Nvidia A100 GPU. For ImageNet-1K we use a setup of 8 NVIDIA A100.

### Reproducing Tables 3 and 4

Run the following command:
```shell
bash scripts/uni/<METHOD>/<DATASET>_multiseed.sh
```

Where METHOD should be in `de`, `nlc`, `adp`, `dice`, `gradcam` (our); DATASET in
`cifar10`, `cifar100`, `mnist`, `imagenet`. This will run training, OOD evaluation, and calibration pipelines.

The results will appear in wandb.

### Reproducing Table 2 and 4

Run the following command:
```shell
bash scripts/uni/<METHOD>/<DATASET>_eval_ece.sh
```

Where METHOD should be in `de`, `nlc`, `adp`, `dice`, `gradcam` (our); DATASET in
`cifar10`, `cifar100`, `mnist`, `imagenet`. This will run calibration and accuracy evaluation pipeline.

The results will appear in wandb.
