#!/bin/bash

EXP_NAME='tin-gradcam-logitnorm-hopt'


PYTHONPATH='.':$PYTHONPATH \
python3 main.py \
--config configs/datasets/tin/tin.yml \
configs/datasets/tin/tin_ood.yml \
configs/networks/resnet18_64x64_ensemble.yml \
configs/preprocessors/base_preprocessor.yml \
configs/pipelines/train/train_gradcam_hopt.yml \
configs/postprocessors/deed.yml \
--optimizer.num_epochs 100 \
--num_workers 8 \
--exp_name "hopt" \
--output_dir "/results/$EXP_NAME" \
--recorder.project ded \
--recorder.experiment "$EXP_NAME" \
--recorder.group "$EXP_NAME" \
--loss.cls_loss "logitnorm" \
--postprocessor.postprocessor_args.network_name resnet18_64x64_ensemble \
--postprocessor.postprocessor_args.num_networks 5 \
--postprocessor.postprocessor_args.aggregation 'logit-average'
