import pandas as pd
import argparse
import numpy as np
import sys
import os

def analyze(csv_file):
    print(csv_file)
    if not os.path.exists(csv_file):
        raise FileNotFoundError 
    df = pd.read_csv(csv_file)
    print("%d" %len(df) + " lines Found")
    if len(df) > 0:
        avg_p1_winrate = df['p1_winrate'].mean() * 100
        avg_p2_winrate = df['p2_winrate'].mean() * 100
        output_str = "Avg_p1_winrate: %.1f" %avg_p1_winrate+ "   Avg_p2_winrate: %.1f" %avg_p2_winrate
        os.path.exists(output_str + ".txt")
        print(output_str)

if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--model")
    args = parser.parse_args()
    analyze(args.model + "/result.csv")
