#!/bin/bash

TEST_SCRIPT="./MCTS_test.py"
ANALYZE_SCRIPT="./analyze_result.py"
LOG_FILE="test_log.txt"

> "$LOG_FILE"

trap "echo 'Interrupted. Killing all subprocesses...'; kill 0; exit 1" SIGINT

N=20
MODELS=(
    "outputs/Breakthrough_LGAN_DQN_512_4_24_mean_seed_1/breakthrough(rows=8,columns=8)_p2_round_0" 
    "outputs/Breakthrough_LGAN_DQN_512_4_24_mean_seed_1/breakthrough(rows=8,columns=8)_p2_round_1" 
    "outputs/Breakthrough_LGAN_DQN_512_4_24_mean_seed_1/breakthrough(rows=8,columns=8)_p2_round_2" 
    "outputs/Breakthrough_LGAN_DQN_512_4_24_mean_seed_1/breakthrough(rows=8,columns=8)_p2_round_3" 
    "outputs/Breakthrough_LGAN_DQN_512_4_24_mean_seed_1/breakthrough(rows=8,columns=8)_p2_round_4" 
    "outputs/Breakthrough_LGAN_DQN_512_4_24_mean_seed_1/breakthrough(rows=8,columns=8)_p2_round_5" 
    "outputs/Breakthrough_LGAN_DQN_512_4_24_mean_seed_1/breakthrough(rows=8,columns=8)_p2_round_6" 
    "outputs/Breakthrough_LGAN_DQN_512_4_24_mean_seed_1/breakthrough(rows=8,columns=8)_p2_round_7" 
    "outputs/Breakthrough_LGAN_DQN_512_4_24_mean_seed_1/breakthrough(rows=8,columns=8)_p2_round_8" 
    "outputs/Breakthrough_LGAN_DQN_512_4_24_mean_seed_1/breakthrough(rows=8,columns=8)_p2_round_9" 
    "outputs/Breakthrough_LGAN_DQN_512_4_24_mean_seed_1/breakthrough(rows=8,columns=8)_p2_round_10" 
    "outputs/Breakthrough_LGAN_DQN_512_4_24_mean_seed_1/breakthrough(rows=8,columns=8)_p2_round_11" 
    "outputs/Breakthrough_LGAN_DQN_512_4_24_mean_seed_1/breakthrough(rows=8,columns=8)_p2_round_12" 
    "outputs/Breakthrough_LGAN_DQN_512_4_24_mean_seed_1/breakthrough(rows=8,columns=8)_p2_round_13" 
    "outputs/Breakthrough_LGAN_DQN_512_4_24_mean_seed_1/breakthrough(rows=8,columns=8)_p2_round_14" 
    "outputs/Breakthrough_LGAN_DQN_512_4_24_mean_seed_1/breakthrough(rows=8,columns=8)_p2_round_15" 
    "outputs/Breakthrough_LGAN_DQN_512_4_24_mean_seed_1/breakthrough(rows=8,columns=8)_p2_round_16" 
)

for MODEL in "${MODELS[@]}"; do
    PIDS=()
    for ((i=1; i<=N; i++)); do
        python -u "$TEST_SCRIPT" --model "$MODEL" --group_size "50" --seed "$i" >> "$LOG_FILE" 2>&1 &
        PIDS+=($!)
    done

    for pid in "${PIDS[@]}"; do
        wait $pid
    done

    python "$ANALYZE_SCRIPT" --model "$MODEL"

    echo "Test Finished for $MODEL"
done

echo "All Test Finished"