# Project Title

A brief description of the project.

## Environment Setup

These instructions were tested on **Ubuntu 22.04** with an **NVIDIA RTX 4090** (Driver Version 580.65.06).

### 1.  NVIDIA Driver

sudo apt purge nvidia-*
sudo apt autoremove
sudo apt autoclean
sudo apt install nvidia-driver-580
restart the computer
nvidia-smi
+-----------------------------------------------------------------------------------------+
| NVIDIA-SMI 580.65.06              Driver Version: 580.65.06      CUDA Version: 13.0     |
+-----------------------------------------+------------------------+----------------------+
| GPU  Name                 Persistence-M | Bus-Id          Disp.A | Volatile Uncorr. ECC |
| Fan  Temp   Perf          Pwr:Usage/Cap |           Memory-Usage | GPU-Util  Compute M. |
|                                         |                        |               MIG M. |
|=========================================+========================+======================|
|   0  NVIDIA GeForce RTX 4090        Off |   00000000:01:00.0 Off |                  Off |
|  0%   31C    P0             44W /  450W |      15MiB /  24564MiB |      0%      Default |
|                                         |                        |                  N/A |
+-----------------------------------------+------------------------+----------------------+

+-----------------------------------------------------------------------------------------+
| Processes:                                                                              |
|  GPU   GI   CI              PID   Type   Process name                        GPU Memory |
|        ID   ID                                                               Usage      |
|=========================================================================================|
|    0   N/A  N/A            1497      G   /usr/lib/xorg/Xorg                        4MiB |
+-----------------------------------------------------------------------------------------+



### 2. Python Environment & Dependencies

We use a Python virtual environment to manage dependencies, ensuring the project does not interfere with your system-wide packages.

# 1. Install Python 3.13 if you don't have it.
sudo apt update
sudo apt install software-properties-common -y
sudo add-apt-repository ppa:deadsnakes/ppa

# 2. Create and activate the virtual environment
python3.13 -m venv forlgan
source forlgan/bin/activate

# 3. Install all required packages
pip3 install torch torchvision --index-url https://download.pytorch.org/whl/cu129
pip install open_spiel
pip install seaborn
`requirements.txt` attached

### Usage instruction
Read experiment_setting.yaml for the experiment you want to try
Modify the file batch_train.sh. Add the experiment to the array EXPERIMENTS
Run the experiment by using ./batch_train.sh
If everything is fine, you should see someing start with 
