#!/bin/bash

TRAIN_SCRIPT="./train.py"
EXPERIMENTS=("TTT_LGAN_DQN_24_mean")

trap "echo 'Interrupted. Killing all subprocesses...'; kill 0; exit 1" SIGINT

for RANDOM_SEED in {0..0}; do
    for EXP in "${EXPERIMENTS[@]}"; do
        echo "Experiment: $EXP started, Seed: $RANDOM_SEED"
        mkdir -p "outputs/${EXP}_seed_$RANDOM_SEED"
        LOG_FILE="outputs/${EXP}_seed_$RANDOM_SEED/train_log.txt"
        python -u "$TRAIN_SCRIPT" --name "$EXP" --seed "$RANDOM_SEED" --mode "ttt" 2>&1 | tee -a "$LOG_FILE"
        echo "Experiment Finished for $EXP"
    done
done
echo "All Experiments Finished"
