
import numpy as np
import pyspiel
import copy 
def state_vec_to_player_observation(game_name, time_step, player_id):
    """Convert a serialized state vector to a player's observation string.
    Args:
      game_name: string, the name of the game.
      time_step: a `TimeStep` object from OpenSpiel.
      player_id: int, the player ID.

    Returns:
      A string representing the player's observation.
    """
    if player_id == 0:
        state = np.asarray(time_step.observations["info_state"][player_id])
        return state
    else:
        if 'breakthrough' in game_name:
            state = np.asarray(time_step.observations["info_state"][player_id])
            state[64:128] = state[128:192]
            state[128:192] = state[64:128]
            return state
        else:
            return np.asarray(time_step.observations["info_state"][player_id])