#!/bin/bash

# download the swe-v annotation datasets from openai
printf "\nDownloading and extracting annotation datasets\n\n"
curl -o inputs/swe-bench-annotation-results.zip https://cdn.openai.com/introducing-swe-bench-verified/swe-bench-annotation-results.zip
unzip inputs/swe-bench-annotation-results.zip -d inputs/swe-bench-annotation-results

# pre-process as required for each experiment
python src/preprocess_experiment1.py
python src/preprocess_experiment2.py
python src/preprocess_experiment3.py

# remove the openai datasets
printf "\nRemoving downloaded datasets\n"
rm -r inputs/swe-bench-annotation-results
rm inputs/swe-bench-annotation-results.zip

printf "\nPre-processing complete\n\n"
