import tensorflow as tf

def ComputeGradient(gradients, previous_loss_ratios):
    '''
    gradients:    gradients from each activate tasks
    previous_loss_ratios:  l_{k-1}/l_{k-2} the previous loss ratio values for each tasks
    '''
    d = []
    w = tf.nn.softmax(previous_loss_ratios)
    w = tf.cast(w, dtype=tf.float64)
    for k in range(len(gradients[0])): # for each layer
        g = 0
        for i in range(len(gradients)):
            g += (w[i]/len(gradients))*gradients[i][k]
        d.append(g)
    return d

