import tensorflow as tf
from . import min_norm_solvers

def ComputeGradient(gradients):
   
    gs = []
    for i in range(len(gradients)): # for each task
        g_task_flat = tf.concat([tf.reshape(grad, [-1]) for grad in gradients[i]], 0)
        gs.append(g_task_flat)
    sol, min_norm = min_norm_solvers.find_min_norm_element(gs)

    d = []
    for k in range(len(gradients[0])):
        g = 0
        for i in range(len(gradients)): # for each task
            g += sol[i] * gradients[i][k]
        d.append(g)
    return d