import tensorflow as tf
import numpy as np

def ComputeGradient(gradients):
    gradients_flat = [tf.concat([tf.reshape(grad, [-1]) for grad in gradients[k]], 0) for k in range(len(gradients))]
    g_pc= []
    for i in range(len(gradients_flat)): # for each task
        g_list = list(range(len(gradients)))
        g_list.pop(i)
        sample_index = np.random.choice(g_list)
        sample_g = gradients[sample_index]
        sample_g_flat = gradients_flat[sample_index]
        dotp = tf.reduce_sum(tf.multiply(gradients_flat[i], sample_g_flat))
        ref_mag = tf.reduce_sum(tf.multiply(sample_g_flat, sample_g_flat))
        proj = [(1/len(gradients))*(gradients[i][k] - ((dotp/ ref_mag) * sample_g[k])) for k in range(len(gradients[0]))] # for each layer
        nonproj = [(1/len(gradients))*(gradients[i][k]) for k in range(len(gradients[0]))] # for each layer
        g_pc.append(tf.cond(tf.greater_equal(dotp, 0), lambda: nonproj, lambda: proj))
        # release
    return [tf.reduce_sum([g_pc[i][k] for i in range(len(gradients))], 0) for k in range(len(gradients[0]))]

