import argparse
import torch
import os
import json
from tqdm import tqdm
import shortuuid
import sys
import os
sys.path.append(os.path.dirname(os.path.dirname(os.path.dirname(os.path.abspath(__file__)))))
sys.path.append(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))
# print(os.path.dirname(os.path.dirname(os.path.dirname(os.path.abspath(__file__)))))
from llava.constants import IMAGE_TOKEN_INDEX, DEFAULT_IMAGE_TOKEN, DEFAULT_IM_START_TOKEN, DEFAULT_IM_END_TOKEN
from llava.conversation import conv_templates, SeparatorStyle
from llava.model.builder import load_pretrained_model
from llava.utils import disable_torch_init
from llava.mm_utils import tokenizer_image_token, process_images, get_model_name_from_path, KeywordsStoppingCriteria

from PIL import Image
import math

from lavis.models import load_model_and_preprocess

# import kornia
from transformers import set_seed
from ccd_utils.ccd_sample_vcd import evolve_ccd_sampling
from ccd_utils.vcd_add_noise import add_diffusion_noise
evolve_ccd_sampling()

import warnings
warnings.filterwarnings(action='ignore')

def split_list(lst, n):
    """Split a list into n (roughly) equal-sized chunks"""
    chunk_size = math.ceil(len(lst) / n)  # integer division
    return [lst[i:i+chunk_size] for i in range(0, len(lst), chunk_size)]


def get_chunk(lst, n, k):
    chunks = split_list(lst, n)
    return chunks[k]

def str2bool(v):
    if isinstance(v, bool):
        return v
    if v.lower() in ('yes', 'true', 't', 'y', '1'):
        return True
    elif v.lower() in ('no', 'false', 'f', 'n', '0'):
        return False
    else:
        raise argparse.ArgumentTypeError('Boolean value expected.')

def eval_model(args):
    # Model
    disable_torch_init()
    # model_path = os.path.expanduser(args.model_path)
    model_name = "instructblip"
    # tokenizer, model, image_processor, context_len = load_pretrained_model(model_path, args.model_base, model_name)
    
    model, vis_processors, _ = load_model_and_preprocess(name="blip2_vicuna_instruct", model_type="vicuna7b", is_eval=True, device="cuda")

    questions = [json.loads(q) for q in open(os.path.expanduser(args.question_file), "r")]
    # questions = get_chunk(questions, args.num_chunks, args.chunk_idx)
    answers_file = os.path.expanduser(args.answers_file)
    os.makedirs(os.path.dirname(answers_file), exist_ok=True)
    ans_file = open(answers_file, "w")

    
    for line in tqdm(questions):
    # for (input_ids, image_tensor, image_sizes), line in tqdm(zip(data_loader, questions), total=len(questions)):
        idx = line["question_id"]
        image_file = line["image"]
        qs = line["text"]
        # cur_prompt = qs

        # input_ids = tokenizer_image_token(qs, tokenizer, IMAGE_TOKEN_INDEX, return_tensors='pt').unsqueeze(0).cuda()

        image = Image.open(os.path.join(args.image_folder, image_file)).convert("RGB")
        # import pdb; pdb.set_trace()
        
        image_tensor = vis_processors['eval'](image).unsqueeze(0)
        
        if args.use_ccd:
            image_neg = add_diffusion_noise(image_tensor, args.noise_step)
        else:
            image_neg = None      

        # stop_str = conv.sep if conv.sep_style != SeparatorStyle.TWO else conv.sep2
        # keywords = [stop_str]
        # stopping_criteria = KeywordsStoppingCriteria(keywords, tokenizer, input_ids)

        # with torch.inference_mode():
        #     output_ids = model.generate(
        #         input_ids,
        #         images=image_tensor.unsqueeze(0).half().cuda(),
        #         images_cd=(image_tensor_cd.unsqueeze(0).half().cuda() if image_tensor_cd is not None else None),
        #         cd_alpha = args.cd_alpha,
        #         cd_beta = args.cd_beta,
        #         do_sample=True,
        #         temperature=args.temperature,
        #         top_p=args.top_p,
        #         top_k=args.top_k,
        #         max_new_tokens=1024,
        #         use_cache=True,
        #     )
        # with torch.inference_mode():
        #     with torch.no_grad():
        #         output_ids = model.generate(
        #             input_ids,
        #             images=image_tensor.unsqueeze(0).half().cuda(),
        #             images_pos=None,
        #             images_neg=(image_neg.unsqueeze(0).half().cuda() if image_neg is not None else None),
        #             do_sample=True,
        #             temperature=args.temperature,
        #             top_p=args.top_p,
        #             top_k=args.top_k,
        #             # max_new_tokens=args.max_new_tokens,
        #             use_cache=True,
        #             use_ccd=args.use_ccd,
        #             ccd_alpha_pos=args.ccd_alpha_pos,
        #             ccd_alpha_neg=args.ccd_alpha_neg,
        #             ccd_beta=args.ccd_beta,
        #         )
        with torch.inference_mode():
            outputs = model.generate(
                {"image": image_tensor.cuda().half(), "prompt": qs},
                use_nucleus_sampling=True,
                num_beams=1,
                top_p = args.top_p,
                repetition_penalty=1,
                # images_cd=image_tensor_cd,
                # cd_beta = args.cd_beta,
                use_ccd=args.use_ccd,
                ccd_alpha_pos=args.ccd_alpha_pos,
                ccd_alpha_neg=args.ccd_alpha_neg,
                ccd_beta=args.ccd_beta,
                images_pos=None,
                images_neg=(image_neg.half().cuda() if image_neg is not None else None) 
            )
            

        # input_token_len = input_ids.shape[1]
        # n_diff_input_output = (input_ids != output_ids[:, :input_token_len]).sum().item()
        # if n_diff_input_output > 0:
        #     print(f'[Warning] {n_diff_input_output} output_ids are not the same as the input_ids')
        # outputs = tokenizer.batch_decode(output_ids[:, input_token_len:], skip_special_tokens=True)[0]
        # outputs = outputs.strip()
        # if outputs.endswith(stop_str):
        #     outputs = outputs[:-len(stop_str)]
        # outputs = outputs.strip()

        outputs = outputs[0]
        
        ans_file.write(json.dumps({"question_id": idx,
                                   "prompt": qs,
                                   "text": outputs,
                                   "model_id": model_name,
                                   "image": image_file,
                                   "metadata": {}}) + "\n")
        ans_file.flush()
    ans_file.close()

if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--model-path", type=str, default="liuhaotian/llava-v1.5-7b")
    parser.add_argument("--model-base", type=str, default=None)
    parser.add_argument("--image-folder", type=str, default="")
    parser.add_argument("--question-file", type=str, default="tables/question.jsonl")
    parser.add_argument("--answers-file", type=str, default="answer.jsonl")
    parser.add_argument("--conv-mode", type=str, default="llava_v1")
    parser.add_argument("--num-chunks", type=int, default=1)
    parser.add_argument("--chunk-idx", type=int, default=0)
    parser.add_argument("--temperature", type=float, default=1.0)
    parser.add_argument("--top_p", type=float, default=1)
    parser.add_argument("--top_k", type=int, default=None)

    parser.add_argument("--noise_step", type=int, default=500)
    parser.add_argument("--cd_alpha", type=float, default=1)
    parser.add_argument("--cd_beta", type=float, default=0.1)
    parser.add_argument("--seed", type=int, default=42)

    parser.add_argument("--use_ccd", type=str2bool, default=False)
    parser.add_argument("--ccd_alpha_pos", type=float, default=0)
    parser.add_argument("--ccd_alpha_neg", type=float, default=1)
    parser.add_argument("--ccd_beta", type=float, default=0.1)

    parser.add_argument("--max_new_tokens", type=int, default=1024)
    args = parser.parse_args()
    set_seed(args.seed)
    eval_model(args)
