import seaborn as sns

AGENT_DISPLAY_NAMES = {
    'single': r'\textsc{Single}',
    'random': r'\textsc{Random}',
    'kmedoids': r'\textsc{K-Medoids}',
    'samplegreedy': r'\textsc{SampleGreedy}',
    'reppopmapped_one': r'\textsc{RepPop}$_{\mathrm{mapped}-1}$ (ours)',
    'reppopmapped_two':     r'\textsc{RepPop}$_{\mathrm{mapped}-2}$ (ours)',
    'reppopdemo':      r'\textsc{RepPop}$_{\mathrm{demo}}$ (ours)',
}

AGENT_LEGEND_ORDER = [
    r'\textsc{Single}', 
    r'\textsc{Random}', 
    r'\textsc{K-Medoids}',
    r'\textsc{SampleGreedy}',
    r'\textsc{RepPop}$_{\mathrm{demo}}$ (ours)',
    r'\textsc{RepPop}$_{\mathrm{mapped}-1}$ (ours)',
    r'\textsc{RepPop}$_{\mathrm{mapped}-2}$ (ours)',
]


palette = sns.color_palette("deep")
AGENT_PLOT_STYLES = {
    'single': {'color': 'darkgray', 'marker': 'D', 'zorder': 5, 'text_color': 'black'},
    'random': {'color':  'lightcoral', 'marker': 'X', 'zorder': 6, 'text_color': 'black'},
    'kmedoids': {'color': 'orange', 'marker': 'h', 'zorder': 7, 'text_color': 'black'},
    'samplegreedy': {'color': 'mediumturquoise', 'marker': 'p', 'zorder': 8, 'text_color': 'black'},
    'reppopdemo': {'color': 'green', 'marker': 's', 'zorder': 9, 'text_color': 'white'}, # Higher z-order
    'reppopmapped_one': {'color': 'purple', 'marker': '^', 'zorder': 10, 'text_color': 'white'}, # Higher z-order
    'reppopmapped_two': {'color': 'blue', 'marker': '^', 'zorder': 10, 'text_color': 'white'}, # Higher z-order
}