# DO-SHAP

## Setup

* Define env variables:
    * `DATA_DIR`: absolute path to the data folder
    * `CONF_DIR`: absolute path to the conf folder
    * `RESULTS_DIR`: absolute path to the results folder.
    * `PYTHONPATH`: add the absolute path to the include folder.
    * PYTORCH_ENABLE_MPS_FALLBACK=1: there's a function which isn't supported in MPS yet
* Install `do_shap` in your Python environment, which takes care of all requirements.
    * Check pyproject.toml for the list of dependencies.

## Running the experiments
* Use .vscode/launch.json settings to run the Synthetic Experiment.
    * Mrkv/Semi - All: runs all replications of the experiment.
    * notebooks/synthetic contains the plotting code for these experiments.
* Run scripts/frontiers.py and time_ablation.py for the FRA experiments.
    * notebooks/frontiers contains the plotting code for these experiments.
* Run scripts/time_ablation_K100.py for the K=100 experiment.
* notebooks/Cache contains the plotting code for Appendix B.
* notebooks/Identifiability contains the identifiability checks for our experiments.
* notebooks/bike-rental and notebooks/diabetes contains all code for these real-world dataset experiments.
* notebooks/Comparison SHAP  contains the marginal-/conditional-/do-SHAP comparison shown in Appendix G.
