import os


def make_path(*xs: str) -> str:
    """Transform UNIX-like path into OS-appropriate path"""
    return os.path.join(*sum(map(lambda x: x.split('/'), xs), []))


def try_mkdir(path: str) -> bool:
    """Try to create a directory and return whether it didn't exist"""
    try:
        os.makedirs(path)
        return True
    except FileExistsError:
        # Directory already exists
        return False
